/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.springframework.jms.connection.JmsTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class ActiveMQRouteTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;
    protected String startEndpointUri = "activemq:queue:test.a";

    public void testJmsRouteWithTextMessage() throws Exception {
        String expectedBody = "Hello there!";
        this.resultEndpoint.expectedBodiesReceived(new Object[]{expectedBody});
        this.resultEndpoint.message(0).header("cheese").isEqualTo((Object)123);
        this.sendExchange(expectedBody);
        this.resultEndpoint.assertIsSatisfied();
    }

    protected void sendExchange(Object expectedBody) {
        this.template.sendBodyAndHeader(this.startEndpointUri, expectedBody, "cheese", (Object)123);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = (MockEndpoint)this.context.getEndpoint("mock:result");
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        camelContext.addComponent("activemq", (Component)ActiveMQComponent.activeMQComponent((String)"vm://localhost?broker.persistent=false"));
        return camelContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from(ActiveMQRouteTest.this.startEndpointUri).to("activemq:queue:test.b");
                this.from("activemq:queue:test.b").to("mock:result");
                JmsEndpoint endpoint1 = (JmsEndpoint)this.endpoint("activemq:topic:quote.IONA");
                endpoint1.getConfiguration().setTransactionManager((PlatformTransactionManager)new JmsTransactionManager());
                endpoint1.getConfiguration().setTransacted(true);
                this.from((Endpoint)endpoint1).to("mock:transactedClient");
                JmsEndpoint endpoint2 = (JmsEndpoint)this.endpoint("activemq:topic:quote.IONA");
                endpoint2.getConfiguration().setTransacted(false);
                this.from((Endpoint)endpoint2).to("mock:nonTrasnactedClient");
            }
        };
    }
}

