/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.deployer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.deployer.ConfigurationManager;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.Scanner;
import org.mortbay.xml.XmlConfiguration;

public class ContextDeployer
extends AbstractLifeCycle {
    public static final String NAME = "ConfiguredDeployer";
    private int _scanInterval = 10;
    private Scanner _scanner;
    private ScannerListener _scannerListener;
    private Resource _configurationDir;
    private Map _currentDeployments = new HashMap();
    private ContextHandlerCollection _contexts;
    private ConfigurationManager _configMgr;
    private boolean _recursive = false;

    public ContextDeployer() throws Exception {
        this._scanner = new Scanner();
    }

    public ContextHandlerCollection getContexts() {
        return this._contexts;
    }

    public void setContexts(ContextHandlerCollection contexts) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot set Contexts after deployer start");
        }
        this._contexts = contexts;
    }

    public void setScanInterval(int seconds) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot change scan interval after deployer start");
        }
        this._scanInterval = seconds;
    }

    public int getScanInterval() {
        return this._scanInterval;
    }

    public void setConfigurationDir(String dir) throws Exception {
        this.setConfigurationDir(Resource.newResource(dir));
    }

    public void setConfigurationDir(File file) throws Exception {
        this.setConfigurationDir(Resource.newResource(file.toURL()));
    }

    public void setConfigurationDir(Resource resource) {
        if (this.isStarted() || this.isStarting()) {
            throw new IllegalStateException("Cannot change hot deploy dir after deployer start");
        }
        this._configurationDir = resource;
    }

    public void setDirectory(String directory) throws Exception {
        this.setConfigurationDir(directory);
    }

    public String getDirectory() {
        return this.getConfigurationDir().getName();
    }

    public Resource getConfigurationDir() {
        return this._configurationDir;
    }

    public void setConfigurationManager(ConfigurationManager configMgr) {
        this._configMgr = configMgr;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configMgr;
    }

    public void setRecursive(boolean recursive) {
        this._recursive = recursive;
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    private void deploy(String filename) throws Exception {
        ContextHandler context = this.createContext(filename);
        Log.info((String)("Deploy " + filename + " -> " + context));
        this._contexts.addHandler(context);
        this._currentDeployments.put(filename, context);
        if (this._contexts.isStarted()) {
            context.start();
        }
    }

    private void undeploy(String filename) throws Exception {
        ContextHandler context = (ContextHandler)this._currentDeployments.get(filename);
        Log.info((String)("Undeploy " + filename + " -> " + context));
        if (context == null) {
            return;
        }
        context.stop();
        this._contexts.removeHandler(context);
        this._currentDeployments.remove(filename);
    }

    private void redeploy(String filename) throws Exception {
        this.undeploy(filename);
        this.deploy(filename);
    }

    protected void doStart() throws Exception {
        if (this._configurationDir == null) {
            throw new IllegalStateException("No configuraition dir specified");
        }
        if (this._contexts == null) {
            throw new IllegalStateException("No context handler collection specified for deployer");
        }
        this._scanner.setScanDir(this._configurationDir.getFile());
        this._scanner.setScanInterval(this.getScanInterval());
        this._scanner.setRecursive(this._recursive);
        this._scanner.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                try {
                    return name.endsWith(".xml") && dir.equals(ContextDeployer.this.getConfigurationDir().getFile());
                }
                catch (IOException e) {
                    Log.warn((Throwable)e);
                    return false;
                }
            }
        });
        this._scannerListener = new ScannerListener();
        this._scanner.addListener((Scanner.Listener)this._scannerListener);
        this._scanner.scan();
        this._scanner.start();
        this._contexts.getServer().getContainer().addBean((Object)this._scanner);
    }

    protected void doStop() throws Exception {
        this._scanner.removeListener((Scanner.Listener)this._scannerListener);
        this._scanner.stop();
    }

    private ContextHandler createContext(String filename) throws Exception {
        File hotDeployXmlFile = new File(filename);
        if (!hotDeployXmlFile.exists()) {
            return null;
        }
        XmlConfiguration xmlConfiguration = new XmlConfiguration(hotDeployXmlFile.toURL());
        HashMap<String, Server> properties = new HashMap<String, Server>();
        properties.put("Server", this._contexts.getServer());
        if (this._configMgr != null) {
            properties.putAll(this._configMgr.getProperties());
        }
        xmlConfiguration.setProperties(properties);
        ContextHandler context = (ContextHandler)xmlConfiguration.configure();
        return context;
    }

    protected class ScannerListener
    implements Scanner.DiscreteListener {
        protected ScannerListener() {
        }

        public void fileAdded(String filename) throws Exception {
            ContextDeployer.this.deploy(filename);
        }

        public void fileChanged(String filename) throws Exception {
            ContextDeployer.this.redeploy(filename);
        }

        public void fileRemoved(String filename) throws Exception {
            ContextDeployer.this.undeploy(filename);
        }

        public String toString() {
            return "ContextDeployer$Scanner";
        }
    }
}

