/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MirroredQueue
implements DestinationInterceptor,
BrokerServiceAware {
    private static final transient Log LOG = LogFactory.getLog(MirroredQueue.class);
    private String prefix = "VirtualTopic.Mirror.";
    private String postfix = "";
    private boolean copyMessage = true;
    private BrokerService brokerService;

    public Destination intercept(final Destination destination) {
        if (destination.getActiveMQDestination().isQueue() && (!destination.getActiveMQDestination().isTemporary() || this.brokerService.isUseTempMirroredQueues())) {
            try {
                final Destination mirrorDestination = this.getMirrorDestination(destination);
                if (mirrorDestination != null) {
                    return new DestinationFilter(destination){

                        public void send(ProducerBrokerExchange context, Message message) throws Exception {
                            message.setDestination(mirrorDestination.getActiveMQDestination());
                            mirrorDestination.send(context, message);
                            if (MirroredQueue.this.isCopyMessage()) {
                                message = message.copy();
                            }
                            message.setDestination(destination.getActiveMQDestination());
                            super.send(context, message);
                        }
                    };
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to lookup the mirror destination for: " + destination + ". Reason: " + e), (Throwable)e);
            }
        }
        return destination;
    }

    public void remove(Destination destination) {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        ActiveMQDestination topic = this.getMirrorTopic(destination.getActiveMQDestination());
        if (topic != null) {
            try {
                this.brokerService.removeDestination(topic);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove mirror destination for " + destination + ". Reason: " + e), (Throwable)e);
            }
        }
    }

    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isCopyMessage() {
        return this.copyMessage;
    }

    public void setCopyMessage(boolean copyMessage) {
        this.copyMessage = copyMessage;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected Destination getMirrorDestination(Destination destination) throws Exception {
        if (this.brokerService == null) {
            throw new IllegalArgumentException("No brokerService injected!");
        }
        ActiveMQDestination topic = this.getMirrorTopic(destination.getActiveMQDestination());
        return this.brokerService.getDestination(topic);
    }

    protected ActiveMQDestination getMirrorTopic(ActiveMQDestination original) {
        return new ActiveMQTopic(this.prefix + original.getPhysicalName() + this.postfix);
    }
}

