/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.handler;

import org.apache.camel.spring.handler.LazyLoadingBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ScriptDefinitionParser
extends LazyLoadingBeanDefinitionParser {
    private final String scriptEngineName;

    public ScriptDefinitionParser(String scriptEngineName) {
        super("org.apache.camel.builder.script.ScriptBuilder", "camel-script");
        this.scriptEngineName = scriptEngineName;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String engine = this.scriptEngineName;
        if (engine == null) {
            engine = element.getAttribute("language");
        }
        builder.addConstructorArg((Object)engine);
        super.doParse(element, parserContext, builder);
        String scriptText = DomUtils.getTextValue((Element)element).trim();
        if (scriptText.length() > 0) {
            builder.addPropertyValue("scriptText", (Object)scriptText);
        }
    }
}

