/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.usage.MemoryUsage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KahaMessageStore
implements MessageStore {
    protected final ActiveMQDestination destination;
    protected final MapContainer<MessageId, Message> messageContainer;
    protected StoreEntry batchEntry;

    public KahaMessageStore(MapContainer<MessageId, Message> container, ActiveMQDestination destination) throws IOException {
        this.messageContainer = container;
        this.destination = destination;
    }

    protected MessageId getMessageId(Object object) {
        return ((Message)object).getMessageId();
    }

    public Object getId() {
        return this.messageContainer.getId();
    }

    @Override
    public synchronized void addMessage(ConnectionContext context, Message message) throws IOException {
        this.messageContainer.put(message.getMessageId(), message);
    }

    @Override
    public synchronized Message getMessage(MessageId identity) throws IOException {
        Message result = this.messageContainer.get(identity);
        return result;
    }

    protected boolean recoverMessage(MessageRecoveryListener listener, Message msg) throws Exception {
        listener.recoverMessage(msg);
        return listener.hasSpace();
    }

    @Override
    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.removeMessage(ack.getLastMessageId());
    }

    public synchronized void removeMessage(MessageId msgId) throws IOException {
        StoreEntry entry = this.messageContainer.getEntry(msgId);
        if (entry != null) {
            this.messageContainer.remove(entry);
            if (this.messageContainer.isEmpty() || this.batchEntry != null && this.batchEntry.equals(entry)) {
                this.resetBatching();
            }
        }
    }

    @Override
    public synchronized void recover(MessageRecoveryListener listener) throws Exception {
        Message msg;
        StoreEntry entry = this.messageContainer.getFirst();
        while (entry != null && this.recoverMessage(listener, msg = this.messageContainer.getValue(entry))) {
            entry = this.messageContainer.getNext(entry);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public synchronized void removeAllMessages(ConnectionContext context) throws IOException {
        this.messageContainer.clear();
    }

    @Override
    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public synchronized void delete() {
        this.messageContainer.clear();
    }

    @Override
    public void setMemoryUsage(MemoryUsage memoryUsage) {
    }

    @Override
    public int getMessageCount() {
        return this.messageContainer.size();
    }

    public MessageId getPreviousMessageIdToDeliver(MessageId id) throws Exception {
        return null;
    }

    @Override
    public synchronized void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        StoreEntry entry = this.batchEntry;
        if (entry == null) {
            entry = this.messageContainer.getFirst();
        } else {
            entry = this.messageContainer.refresh(entry);
            if ((entry = this.messageContainer.getNext(entry)) == null) {
                this.batchEntry = null;
            }
        }
        if (entry != null) {
            int count = 0;
            do {
                Message msg;
                if ((msg = this.messageContainer.getValue(entry)) != null) {
                    this.recoverMessage(listener, msg);
                    ++count;
                }
                this.batchEntry = entry;
            } while ((entry = this.messageContainer.getNext(entry)) != null && count < maxReturned && listener.hasSpace());
        }
    }

    @Override
    public synchronized void resetBatching() {
        this.batchEntry = null;
    }

    public boolean isSupportForCursors() {
        return true;
    }
}

