/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;

public class MessageCompressionTest
extends TestCase {
    private static final String BROKER_URL = "tcp://localhost:61216";
    private static final String TEXT = "The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. The quick red fox jumped over the lazy brown dog. ";
    protected BrokerService broker;
    private ActiveMQQueue queue;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        TransportConnector tc = new TransportConnector();
        tc.setUri(new URI(BROKER_URL));
        tc.setName("tcp");
        this.queue = new ActiveMQQueue("TEST." + System.currentTimeMillis());
        this.broker.addConnector(tc);
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void testTextMessageCompression() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(BROKER_URL);
        factory.setUseCompression(true);
        this.sendTestMessage(factory, TEXT);
        ActiveMQTextMessage message = this.receiveTestMessage(factory);
        int compressedSize = message.getContent().getLength();
        factory = new ActiveMQConnectionFactory(BROKER_URL);
        factory.setUseCompression(false);
        this.sendTestMessage(factory, TEXT);
        message = this.receiveTestMessage(factory);
        int unCompressedSize = message.getContent().getLength();
        MessageCompressionTest.assertTrue((String)("expected: compressed Size '" + compressedSize + "' < unCompressedSize '" + unCompressedSize + "'"), (compressedSize < unCompressedSize ? 1 : 0) != 0);
    }

    private void sendTestMessage(ActiveMQConnectionFactory factory, String message) throws JMSException {
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        Session session = connection.createSession(false, 0);
        MessageProducer producer = session.createProducer(this.queue);
        producer.send(session.createTextMessage(message));
        connection.close();
    }

    private ActiveMQTextMessage receiveTestMessage(ActiveMQConnectionFactory factory) throws JMSException {
        ActiveMQConnection connection = (ActiveMQConnection)factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 0);
        MessageConsumer consumer = session.createConsumer(this.queue);
        ActiveMQTextMessage rc = (ActiveMQTextMessage)consumer.receive();
        connection.close();
        return rc;
    }
}

