/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.impl.RouteContext;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlRootElement(name="xquery")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XQueryExpression
extends NamespaceAwareExpression {
    private static final transient Log LOG = LogFactory.getLog(XQueryExpression.class);
    @XmlAttribute(required=false)
    private String type;
    @XmlTransient
    private Class resultType;

    public XQueryExpression() {
    }

    public XQueryExpression(String expression) {
        super(expression);
    }

    public String getLanguage() {
        return "xquery";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    protected void configureExpression(RouteContext routeContext, Expression expression) {
        super.configureExpression(routeContext, expression);
        this.updateResultType();
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
    }

    protected void configurePredicate(RouteContext routeContext, Predicate predicate) {
        super.configurePredicate(routeContext, predicate);
        this.updateResultType();
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
    }

    private void updateResultType() {
        if (this.resultType == null && this.type != null) {
            try {
                this.resultType = Class.forName(this.type);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("ClassNotFoundException creating class: " + this.type));
            }
        }
    }
}

