/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetConsumer;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.EventDrivenPollingConsumer;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetEndpoint
extends MockEndpoint
implements Service {
    private static final transient Log LOG = LogFactory.getLog(DataSetEndpoint.class);
    private DataSet dataSet;
    private AtomicInteger receivedCounter = new AtomicInteger();
    private long produceDelay = -1L;
    private long consumeDelay = -1L;
    private long startTime;

    public DataSetEndpoint(String endpointUri, Component component, DataSet dataSet) {
        super(endpointUri, component);
        this.dataSet = dataSet;
    }

    public static void assertEquals(String description, Object expected, Object actual, Exchange exchange) {
        if (!ObjectHelper.equal(expected, actual)) {
            throw new AssertionError((Object)(description + " does not match. Expected: " + expected + " but was: " + actual + " on  " + exchange + " with headers: " + exchange.getIn().getHeaders()));
        }
    }

    @Override
    public PollingConsumer<Exchange> createPollingConsumer() throws Exception {
        return new EventDrivenPollingConsumer<Exchange>(this);
    }

    @Override
    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        return new DataSetConsumer(this, processor);
    }

    @Override
    public void reset() {
        super.reset();
        this.receivedCounter.set(0);
    }

    @Override
    public int getReceivedCounter() {
        return this.receivedCounter.get();
    }

    public Exchange createExchange(long messageIndex) throws Exception {
        Object exchange = this.createExchange();
        this.getDataSet().populateMessage((Exchange)exchange, messageIndex);
        Message in = exchange.getIn();
        in.setHeader("camelDataSetIndex", messageIndex);
        return exchange;
    }

    @Override
    protected void waitForCompleteLatch() throws InterruptedException {
        long size = this.getDataSet().getSize();
        this.setResultWaitTime(size *= 4000L);
        super.waitForCompleteLatch();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public long getConsumeDelay() {
        return this.consumeDelay;
    }

    public void setConsumeDelay(long consumeDelay) {
        this.consumeDelay = consumeDelay;
    }

    public long getProduceDelay() {
        return this.produceDelay;
    }

    public void setProduceDelay(long produceDelay) {
        this.produceDelay = produceDelay;
    }

    @Override
    protected void performAssertions(Exchange actual) throws Exception {
        long group;
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        int receivedCount = this.receivedCounter.incrementAndGet();
        long index = receivedCount - 1;
        Exchange expected = this.createExchange(index);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received message: " + index + " = " + actual));
        }
        this.assertMessageExpected(index, expected, actual);
        if (this.consumeDelay > 0L) {
            Thread.sleep(this.consumeDelay);
        }
        if ((long)receivedCount % (group = this.getDataSet().getReportCount()) == 0L) {
            this.reportProgress(actual, receivedCount);
        }
    }

    protected void reportProgress(Exchange actual, int receivedCount) {
        long time = System.currentTimeMillis();
        long elapsed = time - this.startTime;
        this.startTime = time;
        LOG.info((Object)("Received: " + receivedCount + " messages so far. Last group took: " + elapsed + " millis"));
    }

    protected void assertMessageExpected(long index, Exchange expected, Exchange actual) throws Exception {
        long actualCounter = ExchangeHelper.getMandatoryHeader(actual, "camelDataSetIndex", Long.class);
        DataSetEndpoint.assertEquals("Header: camelDataSetIndex", index, actualCounter, actual);
        this.getDataSet().assertMessageExpected(this, expected, actual, index);
    }

    @Override
    public void start() throws Exception {
        long size = this.getDataSet().getSize();
        this.expectedMessageCount((int)size);
    }

    @Override
    public void stop() throws Exception {
    }
}

