/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.ParameterMappingStrategy;
import org.apache.camel.util.CamelContextHelper;

public class ConstantBeanHolder
implements BeanHolder {
    private final Object bean;
    private Processor processor;
    private BeanInfo beanInfo;

    public ConstantBeanHolder(Object bean, BeanInfo beanInfo) {
        this.bean = bean;
        this.beanInfo = beanInfo;
        this.processor = CamelContextHelper.convertTo(beanInfo.getCamelContext(), Processor.class, bean);
    }

    public ConstantBeanHolder(Object bean, CamelContext context) {
        this(bean, new BeanInfo(context, bean.getClass()));
    }

    public ConstantBeanHolder(Object bean, CamelContext context, ParameterMappingStrategy parameterMappingStrategy) {
        this(bean, new BeanInfo(context, bean.getClass(), parameterMappingStrategy));
    }

    public String toString() {
        return this.bean.toString();
    }

    public Object getBean() {
        return this.bean;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }
}

