/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.messaging;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.MonitoredNode;
import fi.csc.microarray.messaging.Node;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.auth.AuthenticatedTopic;
import fi.csc.microarray.messaging.auth.AuthenticationRequestListener;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.NamiMessage;
import fi.csc.microarray.util.KeyAndTrustManager;
import fi.csc.microarray.util.UrlTransferUtil;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.log4j.Logger;

public class MessagingEndpoint
implements MessagingListener {
    private static final Logger logger = Logger.getLogger(MessagingEndpoint.class);
    private static final String RELIABLE_CONNECTION_SPECIFIER = "failover:";
    private final String brokerUrl;
    private final boolean useReliable;
    private final String DEFAULT_REPLY_CHANNEL = Topics.MultiplexName.REPLY_TO.toString();
    private ActiveMQConnection connection;
    private MessagingTopic adminTopic = null;
    private Node master;
    private AuthenticationRequestListener authenticationListener;
    private String sessionID = null;

    public MessagingEndpoint(Node master) throws MicroarrayException {
        this(master, null);
    }

    public MessagingEndpoint(Node master, AuthenticationRequestListener authenticationListener) throws MicroarrayException {
        String password;
        String username;
        this.master = master;
        this.authenticationListener = authenticationListener;
        Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
        if (configuration.getBoolean("messaging", "disable-proxy")) {
            UrlTransferUtil.disableProxies();
        }
        String protocol = configuration.getString("messaging", "broker-protocol");
        String host = configuration.getString("messaging", "broker-host");
        int port = configuration.getInt("messaging", "broker-port");
        if (protocol.trim().equals("") || host.trim().equals("")) {
            throw new RuntimeException("configuration error: protocol or host empty");
        }
        this.useReliable = configuration.getBoolean("messaging", "use-reliable");
        this.brokerUrl = protocol + "://" + host + ":" + port;
        if ("ssl".equals(configuration.getString("messaging", "broker-protocol"))) {
            try {
                KeyAndTrustManager.initialise(configuration.getString("security", "keystore"), configuration.getString("security", "keypass").toCharArray(), configuration.getString("security", "keyalias"), configuration.getString("security", "master-keystore"));
            }
            catch (Exception e) {
                throw new MicroarrayException("could not access SSL keystore", e);
            }
        }
        try {
            username = configuration.getString("security", "username");
            if (username == null || username.trim().length() == 0) {
                throw new IllegalArgumentException("Username was not available from configuration");
            }
            password = configuration.getString("security", "password");
            if (password == null || password.trim().length() == 0) {
                throw new IllegalArgumentException("Password was not available from configuration");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("reading authentication information failed: " + e.getMessage());
        }
        try {
            logger.info((Object)("connecting to " + this.brokerUrl));
            String completeBrokerUrl = this.brokerUrl;
            if (this.useReliable) {
                logger.debug((Object)("testing connecting to " + completeBrokerUrl));
                ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(username, password, completeBrokerUrl);
                TopicConnection tempConnection = connectionFactory.createTopicConnection();
                tempConnection.start();
                tempConnection.stop();
                tempConnection.close();
                completeBrokerUrl = RELIABLE_CONNECTION_SPECIFIER + completeBrokerUrl;
            }
            ActiveMQConnectionFactory reliableConnectionFactory = new ActiveMQConnectionFactory(username, password, completeBrokerUrl);
            this.connection = (ActiveMQConnection)reliableConnectionFactory.createTopicConnection();
            this.connection.setExceptionListener((ExceptionListener)master);
            this.connection.start();
            logger.debug((Object)("connected to " + completeBrokerUrl));
            this.adminTopic = this.createTopic(Topics.Name.ADMIN_TOPIC, MessagingTopic.AccessMode.READ_WRITE);
            this.adminTopic.setListener(this);
            logger.debug((Object)"endpoint created succesfully");
        }
        catch (JMSException e) {
            throw new MicroarrayException("could not connect to message broker at " + this.brokerUrl + " (" + e.getMessage() + ")", (Exception)((Object)e));
        }
    }

    public MessagingTopic createTopic(Topics.Name topicName, MessagingTopic.AccessMode accessMode) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        return new AuthenticatedTopic(session, topicName.toString(), MessagingTopic.Type.NORMAL, accessMode, this.authenticationListener, this);
    }

    public void replyToMessage(NamiMessage original, NamiMessage reply) throws JMSException {
        this.replyToMessage(original, reply, this.DEFAULT_REPLY_CHANNEL);
    }

    public void replyToMessage(NamiMessage original, NamiMessage reply, String replyChannel) throws JMSException {
        reply.setMultiplexChannel(replyChannel);
        Destination replyToDest = original.getReplyTo();
        this.replyToMessage(replyToDest, reply);
    }

    private void replyToMessage(Destination replyToDest, NamiMessage reply) throws JMSException {
        Session session = this.connection.createSession(false, 1);
        MapMessage msg = session.createMapMessage();
        reply.marshal(msg);
        session.createProducer(replyToDest).send((Message)msg);
    }

    public void onNamiMessage(NamiMessage msg) {
        try {
            CommandMessage txtMsg = (CommandMessage)msg;
            logger.debug((Object)("got admin request " + txtMsg.getCommand()));
            if (txtMsg.getCommand().equals("ping")) {
                CommandMessage reply = new CommandMessage("ping-reply");
                reply.addParameter(this.master.getName());
                reply.addParameter(this.master.getHost());
                this.adminTopic.sendMessage(reply);
                logger.debug((Object)("sent ping-reply from " + this.master.getHost() + "/" + this.master.getName()));
            } else if (txtMsg.getCommand().equals("request-load-info") && this.master instanceof MonitoredNode) {
                CommandMessage reply = new CommandMessage("request-load-info-reply");
                MonitoredNode mMaster = (MonitoredNode)this.master;
                reply.addParameter(this.master.getName());
                reply.addParameter(Long.toString(mMaster.countRequestsInProcessing()));
                reply.addParameter(Long.toString(mMaster.getLastProcessingTime()));
                this.adminTopic.sendMessage(reply);
                logger.debug((Object)("sent request-load-info-reply from " + this.master.getHost() + "/" + this.master.getName()));
            }
        }
        catch (JMSException e) {
            logger.error((Object)e);
        }
    }

    public void close() throws JMSException {
        this.connection.stop();
        this.connection.close();
    }

    public AuthenticationRequestListener getAuthenticationListener() {
        return this.authenticationListener;
    }

    public void setAuthenticationListener(AuthenticationRequestListener authenticationListener) {
        this.authenticationListener = authenticationListener;
    }

    public OutputStream createOutputStream(Topic topic) throws JMSException {
        return this.connection.createOutputStream((Destination)topic);
    }

    public InputStream createInputStream(Topic topic) throws JMSException {
        return this.connection.createInputStream((Destination)topic);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }
}

