/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FsfStatus;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Track
implements AreaResultListener {
    private View view;
    private File file;
    private boolean isReversed;

    public Track(View view, File file) {
        this.view = view;
        this.file = file;
    }

    public Track(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions) {
        this(view, file);
        view.getQueueManager().createQueue(file, handler, readInstructions);
    }

    public void initializeListener() {
        if (this.file != null) {
            this.view.getQueueManager().addResultListener(this.file, this);
        }
    }

    public abstract Collection<Drawable> getDrawables();

    protected View getView() {
        return this.view;
    }

    public void updateData() {
        if (this.file != null && this.getMaxHeight() > 0) {
            FsfStatus status = new FsfStatus();
            status.clearQueues = true;
            status.concise = this.isConcised();
            Collection<Content> defCont = this.getDefaultContents();
            this.view.getQueueManager().addAreaRequest(this.file, new AreaRequest(this.view.getBpRegion(), defCont, status), true);
        }
    }

    public abstract Collection<Content> getDefaultContents();

    public abstract boolean isConcised();

    public Collection<Drawable> getEmptyDrawCollection() {
        return new LinkedList<Drawable>();
    }

    public int getMaxHeight() {
        return Integer.MAX_VALUE;
    }

    public void setReverseStrand(boolean b) {
        this.isReversed = b;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    public boolean isForForwardStrand(AreaResult<RegionContent> areaResult) {
        String strand = (String)((RegionContent)areaResult.content).values.get((Object)Content.STRAND);
        return strand == null || strand.trim().equals("+") || strand.trim().equals("F");
    }
}

