/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.LineDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Gene;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneTrack
extends Track {
    private Map<String, Gene> genes = new TreeMap<String, Gene>();
    List<Integer> occupiedSpace = new ArrayList<Integer>();
    private Color color;
    private int RESOLUTION = 512;
    private Point2D[] arrowPoints = new Point2D[]{new Point2D.Double(0.0, 0.25), new Point2D.Double(0.5, 0.25), new Point2D.Double(0.5, 0.0), new Point2D.Double(1.0, 0.5), new Point2D.Double(0.5, 1.0), new Point2D.Double(0.5, 0.75), new Point2D.Double(0.0, 0.75), new Point2D.Double(0.0, 0.25)};
    private boolean wasLastConsied = true;
    private long maxBpLength;

    public GeneTrack(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions, Color color, long maxBpLength) {
        super(view, file, handler, readInstructions);
        this.color = color;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.genes != null) {
            ArrayList<Gene> sortedGenes = new ArrayList<Gene>(this.genes.values());
            Collections.sort(sortedGenes);
            for (Gene gene : sortedGenes) {
                int i;
                long minBp = Long.MAX_VALUE;
                long maxBp = 0L;
                String id = null;
                for (RegionContent part : gene) {
                    Object valueObj = part.values.get((Object)Content.DESCRIPTION);
                    minBp = Math.min(minBp, part.region.start);
                    maxBp = Math.max(maxBp, part.region.end);
                    id = (String)part.values.get((Object)Content.ID);
                }
                if (!new Region(minBp, maxBp).intercepts(this.getView().getBpRegion())) {
                    this.genes.remove(id);
                    continue;
                }
                Rectangle rect = new Rectangle();
                rect.x = this.getView().bpToTrack(minBp);
                rect.width = this.getView().bpToTrack(maxBp) - rect.x;
                for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x; ++i) {
                }
                int end = rect.x + rect.width;
                if (this.occupiedSpace.size() > i) {
                    this.occupiedSpace.set(i, end);
                } else {
                    this.occupiedSpace.add(end);
                }
                rect.y = (int)(this.getView().getTrackHeight() - (float)((i + 1) * 22));
                rect.height = 2;
                rect.y += 4;
                drawables.add(new RectDrawable(rect, Color.darkGray, null));
                rect.y -= 4;
                rect.height = 10;
                if (((String)((RegionContent)gene.first()).values.get((Object)Content.STRAND)).trim().equals("-")) {
                    drawables.addAll(this.getArrowDrawables(rect.x, rect.y, -rect.height, rect.height));
                } else {
                    drawables.addAll(this.getArrowDrawables(rect.x + rect.width, rect.y, rect.height, rect.height));
                }
                String geneId = ((String)((RegionContent)gene.first()).values.get((Object)Content.ID)).split("\"")[1];
                if (rect.width > geneId.length() * 7) {
                    drawables.add(new TextDrawable(rect.x, rect.y, geneId, Color.DARK_GRAY));
                }
                ArrayList<RectDrawable> geneDrawables = new ArrayList<RectDrawable>();
                for (RegionContent part : gene) {
                    Color c;
                    if (part.values == null) {
                        drawables.add(this.createDrawable(part.region.start, part.region.end, this.color));
                        continue;
                    }
                    String value = ((String)part.values.get((Object)Content.DESCRIPTION)).trim();
                    boolean height = false;
                    if (value.equals("CDS")) {
                        c = PartColor.CDS.c;
                    } else if (value.equals("exon")) {
                        c = PartColor.UTR.c;
                    } else if (value.equals("start_codon")) {
                        c = PartColor.START_CODON.c;
                    } else {
                        System.out.println("Gene description not recognised: " + value);
                        c = Color.blue;
                    }
                    rect.x = this.getView().bpToTrack(part.region.start);
                    rect.width = this.getView().bpToTrack(part.region.end) - rect.x;
                    rect.height = 10;
                    geneDrawables.add(new RectDrawable(rect, c, null));
                }
                Collections.sort(geneDrawables, new Comparator<Drawable>(){

                    @Override
                    public int compare(Drawable one, Drawable other) {
                        if (one.color.equals(PartColor.CDS.c) && other.color.equals(PartColor.UTR.c)) {
                            return 1;
                        }
                        if (one.color.equals(PartColor.UTR.c) && other.color.equals(PartColor.CDS.c)) {
                            return -1;
                        }
                        return 0;
                    }
                });
                drawables.addAll(geneDrawables);
            }
        }
        return drawables;
    }

    private Collection<? extends Drawable> getArrowDrawables(int x, int y, int width, int height) {
        Collection<Drawable> parts = this.getEmptyDrawCollection();
        for (int i = 1; i < this.arrowPoints.length; ++i) {
            Point2D p1 = this.arrowPoints[i - 1];
            Point2D p2 = this.arrowPoints[i];
            Point2D.Double p1Scaled = new Point2D.Double((double)x + p1.getX() * (double)width, (double)y + p1.getY() * (double)height);
            Point2D.Double p2Scaled = new Point2D.Double((double)x + p2.getX() * (double)width, (double)y + p2.getY() * (double)height);
            parts.add(new LineDrawable((int)((Point2D)p1Scaled).getX(), (int)((Point2D)p1Scaled).getY(), (int)((Point2D)p2Scaled).getX(), (int)((Point2D)p2Scaled).getY(), Color.black));
        }
        return parts;
    }

    private Drawable createDrawable(long startBp, long endBp, Color c) {
        return this.createDrawable(startBp, endBp, 5, c);
    }

    private Drawable createDrawable(long startBp, long endBp, int height, Color c) {
        int i;
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x + 1; ++i) {
        }
        int end = rect.x + rect.width;
        if (this.occupiedSpace.size() > i) {
            this.occupiedSpace.set(i, end);
        } else {
            this.occupiedSpace.add(end);
        }
        rect.y = (int)(this.getView().getTrackHeight() - (float)((i + 1) * (height + 2)));
        rect.height = height;
        return new RectDrawable(rect, c, null);
    }

    @Override
    public void processAreaResult(AreaResult<RegionContent> areaResult) {
        String id = (String)((RegionContent)areaResult.content).values.get((Object)Content.ID);
        boolean isForwardStrand = this.isForForwardStrand(areaResult);
        if (id != null && this.isReversed() != isForwardStrand) {
            if (!this.genes.containsKey(id)) {
                this.genes.put(id, new Gene());
            }
            this.genes.get(id).add((RegionContent)areaResult.content);
            this.getView().redraw();
        }
    }

    @Override
    public void updateData() {
        if (this.wasLastConsied != this.isConcised()) {
            this.genes.clear();
            this.wasLastConsied = this.isConcised();
        }
        super.updateData();
    }

    @Override
    public int getMaxHeight() {
        if (this.getView().getBpRegion().getLength() <= this.maxBpLength) {
            return super.getMaxHeight();
        }
        return 0;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(Content.DESCRIPTION, Content.STRAND, Content.ID);
    }

    @Override
    public boolean isConcised() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PartColor {
        CDS(new Color(64, 192, 64)),
        UTR(new Color(192, 64, 64)),
        START_CODON(Color.gray);

        public Color c;

        private PartColor(Color c) {
            this.c = c;
        }
    }
}

