/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockTrack
extends Track {
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();
    List<Integer> occupiedSpace = new ArrayList<Integer>();
    private Color color;
    private int RESOLUTION = 512;
    private long maxBpLength;
    private boolean wasLastConsied = true;
    private long minBpLength;

    public BlockTrack(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions, Color color, long minBpLength, long maxBpLength) {
        super(view, file, handler, readInstructions);
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.reads != null) {
            Iterator<RegionContent> iter = this.reads.iterator();
            while (iter.hasNext()) {
                RegionContent read = iter.next();
                Object valueObj = read.values.get((Object)Content.VALUE);
                if (!read.region.intercepts(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                if (valueObj == null) {
                    drawables.add(this.createDrawable(read.region.start, read.region.end, Color.red));
                    continue;
                }
                int limited = Math.min((int)(Math.log(((Float)valueObj).floatValue() * 100.0f) * 50.0), 255);
                limited = Math.max(0, limited);
                Color c = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), limited);
                int height = 10;
                drawables.add(this.createDrawable(read.region.start, read.region.end, height, c));
            }
        }
        return drawables;
    }

    private Drawable createDrawable(long startBp, long endBp, Color c) {
        return this.createDrawable(startBp, endBp, 5, c);
    }

    private Drawable createDrawable(long startBp, long endBp, int height, Color c) {
        int i;
        Rectangle rect = new Rectangle();
        rect.x = this.getView().bpToTrack(startBp);
        rect.width = this.getView().bpToTrack(endBp) - rect.x;
        for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x + 1; ++i) {
        }
        int end = rect.x + rect.width;
        if (this.occupiedSpace.size() > i) {
            this.occupiedSpace.set(i, end);
        } else {
            this.occupiedSpace.add(end);
        }
        rect.y = (int)(this.getView().getTrackHeight() - (float)((i + 1) * (height + 2)));
        rect.height = height;
        return new RectDrawable(rect, c, null);
    }

    @Override
    public void processAreaResult(AreaResult<RegionContent> areaResult) {
        if (areaResult.status.concise == this.isConcised()) {
            this.reads.add((RegionContent)areaResult.content);
            this.getView().redraw();
        }
    }

    @Override
    public void updateData() {
        if (this.wasLastConsied != this.isConcised()) {
            this.reads.clear();
            this.wasLastConsied = this.isConcised();
        }
        super.updateData();
    }

    @Override
    public int getMaxHeight() {
        if (this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength) {
            return super.getMaxHeight();
        }
        return 0;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(new Content[0]);
    }

    @Override
    public boolean isConcised() {
        return this.getView().getBpRegion().getLength() > 0x100000L;
    }
}

