/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.FileDefinition;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class FastaChunkParser
extends ChunkParser {
    private long rowLength;
    private long titleLength;
    File file;

    public FastaChunkParser(FileDefinition fileDef, File file) throws IOException {
        super(fileDef);
        this.file = file;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        this.titleLength = reader.readLine().length() + 1;
        this.rowLength = reader.readLine().length() + 1;
    }

    public FastaChunkParser(FileDefinition fileDef, long rowLength, long titleLength) {
        super(fileDef);
        this.titleLength = titleLength;
        this.rowLength = rowLength;
    }

    public float getFloat(long pos) {
        return Float.NaN;
    }

    public long getLong(long pos) {
        return (this.chunk.readIndex + pos) * this.rowLength;
    }

    public long getPosition(long readIndex, Content rec) {
        return readIndex - this.chunk.readIndex;
    }

    public long getReadCount() {
        return this.chunk.length / this.rowLength;
    }

    public String getString(long pos) {
        return new String(this.getBytes(pos));
    }

    private byte[] getBytes(long pos) {
        byte[] byteValue = new byte[(int)this.rowLength];
        System.arraycopy(this.chunk.content, (int)(pos * this.rowLength), byteValue, 0, byteValue.length);
        return byteValue;
    }

    public long getRowLength() {
        return this.rowLength;
    }

    public ChunkParser clone() {
        return new FastaChunkParser(this.fileDef, this.rowLength, this.titleLength);
    }

    public long getTitleLength() {
        return this.titleLength;
    }
}

