/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.ChipVisualisation;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.VisualisationMethodChangedEvent;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.util.FloatArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.TextAnchor;

public class Histogram
extends ChipVisualisation {
    private JPanel paramPanel;
    private JPanel visualisationPanel = new JPanel(new BorderLayout());
    private JSpinner barCountSpinner = new JSpinner(new SpinnerNumberModel(20, 1, Integer.MAX_VALUE, 1));
    private JButton updateButton;
    private JComboBox chipBox;
    private DataBean data;

    public Histogram(VisualisationFrame frame) {
        super(frame);
    }

    public JComponent getVisualisation(DataBean data) throws Exception {
        this.data = data;
        this.updateHistogram();
        return this.visualisationPanel;
    }

    private void updateHistogram() throws MicroarrayException, IOException {
        this.updateChipBox();
        int barCount = ((SpinnerNumberModel)this.barCountSpinner.getModel()).getNumber().intValue();
        String expression = ((Visualisation.Variable)this.chipBox.getSelectedItem()).getExpression();
        FloatArrayList histogram = this.getHistogram(barCount, expression);
        if (histogram == null) {
            throw new IllegalArgumentException("histogram not supported for " + this.data.getName());
        }
        CategoryDataset dataset = this.toCategoryDataset(histogram);
        CategoryAxis categoryAxis = new CategoryAxis("value");
        NumberAxis valueAxis = new NumberAxis("count");
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition position1 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(position1);
        ItemLabelPosition position2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(position2);
        CategoryPlot plot = new CategoryPlot(dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(this.data.getName(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        this.visualisationPanel.removeAll();
        this.visualisationPanel.add((Component)Histogram.makePanel(chart), "Center");
        this.visualisationPanel.validate();
    }

    public JPanel getParameterPanel() {
        if (this.paramPanel == null) {
            this.paramPanel = new JPanel();
            this.paramPanel.setLayout(new GridBagLayout());
            this.paramPanel.setPreferredSize(Visualisation.PARAMETER_SIZE);
            this.chipBox = new JComboBox();
            this.updateButton = new JButton("Draw");
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ArrayList<Visualisation.Variable> variables = new ArrayList<Visualisation.Variable>();
                        variables.add((Visualisation.Variable)Histogram.this.chipBox.getSelectedItem());
                        Histogram.this.application.setVisualisationMethod(new VisualisationMethodChangedEvent(this, VisualisationMethod.HISTOGRAM, variables, Histogram.this.getFrame().getDatas(), Histogram.this.getFrame().getType(), Histogram.this.getFrame()));
                    }
                    catch (Exception exp) {
                        Histogram.this.application.reportException(exp);
                    }
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.insets.set(5, 10, 5, 10);
            c.anchor = 18;
            c.weightx = 1.0;
            c.fill = 2;
            this.paramPanel.add((Component)new JLabel("Chip to visualise: "), c);
            ++c.gridy;
            this.paramPanel.add((Component)this.chipBox, c);
            ++c.gridy;
            this.paramPanel.add((Component)new JLabel("Number of bins: "), c);
            ++c.gridy;
            this.paramPanel.add((Component)this.barCountSpinner, c);
            ++c.gridy;
            this.paramPanel.add((Component)this.updateButton, c);
            ++c.gridy;
            c.fill = 1;
            c.weighty = 1.0;
            this.paramPanel.add((Component)new JPanel(), c);
        }
        return this.paramPanel;
    }

    private void updateChipBox() {
        if (this.paramPanel == null) {
            throw new IllegalStateException("must call getParameterPanel first");
        }
        Visualisation.fillCompoBox(this.chipBox, this.getVariablesFor(this.data));
        List<Visualisation.Variable> variables = this.getFrame().getVariables();
        if (variables != null && variables.size() > 0) {
            this.chipBox.setSelectedItem(variables.get(0));
        }
    }

    private CategoryDataset toCategoryDataset(FloatArrayList values) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (int i = 0; i < values.size(); ++i) {
            dataset.addValue((Number)values.get(i), (Comparable)((Object)"data"), (Comparable)((Object)("" + i)));
        }
        return dataset;
    }

    private FloatArrayList getHistogram(int histogramSteps, String expression) throws MicroarrayException, IOException {
        Iterable<Float> intensities = this.data.queryFeatures(expression).asFloats();
        LinkedList<Float> values = new LinkedList<Float>();
        for (float intensity : intensities) {
            values.add(Float.valueOf(intensity));
        }
        Collections.sort(values);
        while (((Float)values.get(values.size() - 1)).isNaN()) {
            values.remove(values.size() - 1);
        }
        if (values.size() < histogramSteps) {
            return new FloatArrayList(values);
        }
        float min = ((Float)values.get(0)).floatValue();
        float max = values.get(values.size() - 1).floatValue();
        float stepSize = (max - min) / (float)histogramSteps;
        float[] histogram = new float[histogramSteps];
        int valueIndex = 0;
        float roof = min + stepSize;
        for (int step = 0; step < histogram.length; ++step) {
            while (valueIndex < values.size() && values.get(valueIndex).floatValue() <= roof) {
                int n = step;
                histogram[n] = histogram[n] + 1.0f;
                ++valueIndex;
            }
            roof += stepSize;
        }
        int n = histogram.length - 1;
        histogram[n] = histogram[n] + (float)(values.size() - valueIndex);
        return new FloatArrayList(histogram);
    }
}

