/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.methods.ExpressionProfile;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.MultiChartPanel;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredProfiles
extends Visualisation {
    public ClusteredProfiles(VisualisationFrame frame) {
        super(frame);
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        int clusterCount = 0;
        Iterable<String> clusters = data.queryFeatures("/column/cluster").asStrings();
        for (String cluster : clusters) {
            int num = Integer.parseInt(cluster);
            if (num <= clusterCount) continue;
            clusterCount = num;
        }
        ArrayList<JFreeChart> charts = new ArrayList<JFreeChart>(clusterCount);
        LinkedList<DefaultCategoryDataset> datasets = new LinkedList<DefaultCategoryDataset>();
        LinkedList rows = new LinkedList();
        for (int i = 0; i < clusterCount; ++i) {
            datasets.add(new DefaultCategoryDataset());
            rows.add(new LinkedList());
        }
        TableAnnotationProvider annotationProvider = new TableAnnotationProvider(data);
        Table samples = data.queryFeatures("/column/*").asTable();
        int[] rowNumbers = new int[clusterCount];
        while (samples.nextRow()) {
            int cluster = samples.getIntValue("cluster");
            boolean firstSample = true;
            for (String sample : samples.getColumnNames()) {
                if (!sample.startsWith("chip.")) continue;
                if (firstSample) {
                    ExpressionProfile.ProfileRow row = new ExpressionProfile.ProfileRow();
                    row.value = Float.valueOf(samples.getFloatValue(sample));
                    row.series = rowNumbers[cluster - 1];
                    firstSample = false;
                    ((LinkedList)rows.get(cluster - 1)).add(row);
                }
                String sampleName = data.queryFeatures("/phenodata/linked/describe/" + sample.substring("chip.".length())).asString();
                ((DefaultCategoryDataset)datasets.get(cluster - 1)).addValue((double)samples.getFloatValue(sample), (Comparable)((Object)samples.getStringValue(" ")), (Comparable)((Object)sampleName));
                String rowName = annotationProvider.getAnnotatedRowname(samples.getStringValue(" "));
                ((DefaultCategoryDataset)datasets.get(cluster - 1)).addValue((double)samples.getFloatValue(sample), (Comparable)((Object)rowName), (Comparable)((Object)sampleName));
            }
            int n = cluster - 1;
            rowNumbers[n] = rowNumbers[n] + 1;
        }
        for (int i = 0; i < clusterCount; ++i) {
            charts.add(new ExpressionProfile(null).createProfileChart((CategoryDataset)datasets.get(i), (List)rows.get(i), "Cluster " + (i + 1)));
        }
        return this.makePanel(charts);
    }

    protected JComponent makePanel(List<JFreeChart> charts) {
        int slots;
        int height = slots = (int)Math.ceil(Math.sqrt(charts.size()));
        int width = slots * (slots - 1) >= charts.size() ? slots - 1 : slots;
        JPanel panel = new JPanel(new GridLayout(width, height));
        LinkedList<MultiChartPanel> panels = new LinkedList<MultiChartPanel>();
        for (JFreeChart chart : charts) {
            MultiChartPanel multiPanel = new MultiChartPanel(chart, panels);
            panels.add(multiPanel);
            panel.add((Component)multiPanel);
        }
        return panel;
    }

    @Override
    public boolean canVisualise(DataBean bean) throws MicroarrayException {
        boolean isTabular = VisualisationMethod.SPREADSHEET.getHeadlessVisualiser().canVisualise(bean);
        if (isTabular) {
            Table chips = bean.queryFeatures("/column/chip.*").asTable();
            boolean hasProfiles = chips != null && chips.getColumnNames().length > 1;
            boolean hasClusters = bean.queryFeatures("/column/cluster").exists();
            return hasProfiles && hasClusters;
        }
        return false;
    }
}

