/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.visualisation.TableAnnotationProvider;
import fi.csc.microarray.client.visualisation.VisualisationUtilities;
import fi.csc.microarray.client.visualisation.methods.threed.DataPoint;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateListPanel
extends JPanel {
    private JList selectedList;
    private DefaultListModel selectedListModel;
    private JButton filterButton;
    private List<DataBean> datas = new ArrayList<DataBean>();
    private ClientApplication application = Session.getSession().getApplication();
    private JLabel countLabel;
    private String nameOfItems = "Genes";

    public AnnotateListPanel() {
        this.setLayout(new BorderLayout());
        this.selectedListModel = new DefaultListModel();
        this.selectedList = new JList(this.selectedListModel);
        this.selectedList.setSelectionBackground(this.selectedList.getBackground());
        this.selectedList.setSelectionForeground(this.selectedList.getForeground());
        this.countLabel = new JLabel();
        this.filterButton = new JButton("Create dataset");
        this.filterButton.setToolTipText("Create new dataset from selected genes");
        this.filterButton.setEnabled(false);
        this.filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualisationUtilities.filterBySelection(AnnotateListPanel.this.datas);
            }
        });
        this.add((Component)this.countLabel, "North");
        this.add((Component)new JScrollPane(this.selectedList), "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)this.filterButton, "South");
        this.add((Component)buttonPanel, "South");
    }

    public AnnotateListPanel(String nameOfItems, boolean filterButtonVisible) {
        this();
        this.nameOfItems = nameOfItems;
        this.filterButton.setVisible(filterButtonVisible);
    }

    public void setSelectedListContentMultipleDatas(List<String> content, Map<DataBean, Set<Integer>> indexes, Object source, boolean dispatchEvent) {
        this.setData(indexes.keySet());
        LinkedList<TableAnnotationProvider> annotationProviders = new LinkedList<TableAnnotationProvider>();
        try {
            int i = 0;
            for (DataBean data : indexes.keySet()) {
                annotationProviders.add(new TableAnnotationProvider(data));
            }
            ++i;
        }
        catch (MicroarrayException me) {
            throw new RuntimeException(me);
        }
        this.selectedListModel.removeAllElements();
        this.setCount(content.size());
        this.filterButton.setEnabled(content.size() > 0);
        for (String row : content) {
            String viewName = "";
            for (TableAnnotationProvider annotation : annotationProviders) {
                String annotationStr = annotation.getAnnotatedRowname(row);
                if (annotationStr == null || viewName.contains(annotationStr)) continue;
                if (viewName.length() == 0) {
                    viewName = viewName + annotationStr;
                    continue;
                }
                viewName = viewName + ", " + annotationStr;
            }
            this.selectedListModel.addElement(viewName);
        }
        if (dispatchEvent) {
            for (DataBean data : indexes.keySet()) {
                this.application.getSelectionManager().getRowSelectionManager(data).setSelected(indexes.get(data), source);
            }
        }
    }

    public void setSelectedListContentAsDataPoints(Collection<DataPoint> content, Object source, boolean dispatchEvent, DataBean data) {
        TableAnnotationProvider annotationProvider;
        this.setData(data);
        try {
            annotationProvider = new TableAnnotationProvider(data);
        }
        catch (MicroarrayException me) {
            throw new RuntimeException(me);
        }
        this.selectedListModel.removeAllElements();
        this.setCount(content.size());
        this.filterButton.setEnabled(content.size() > 0);
        int[] indexes = new int[content.size()];
        int i = 0;
        for (DataPoint row : content) {
            this.selectedListModel.addElement(annotationProvider.getAnnotatedRowname(row.toString()));
            indexes[i++] = row.getIndex();
        }
        if (dispatchEvent) {
            this.application.getSelectionManager().getRowSelectionManager(data).setSelected(indexes, source);
        }
    }

    public void setSelectedRows(Set<Integer> rows, Object source, boolean dispatchEvent, DataBean data) {
        TableAnnotationProvider annotationProvider;
        this.setData(data);
        try {
            annotationProvider = new TableAnnotationProvider(data);
        }
        catch (MicroarrayException me) {
            throw new RuntimeException(me);
        }
        this.selectedListModel.removeAllElements();
        this.setCount(rows.size());
        this.filterButton.setEnabled(rows.size() > 0);
        Iterator<String> ids = null;
        try {
            ids = data.queryFeatures("/identifier").asStrings().iterator();
        }
        catch (MicroarrayException e) {
            this.application.reportException(e);
        }
        int i = 0;
        while (ids.hasNext()) {
            String id = ids.next();
            if (rows.contains(i)) {
                this.selectedListModel.addElement(annotationProvider.getAnnotatedRowname(id));
            }
            ++i;
        }
        if (dispatchEvent) {
            this.application.getSelectionManager().getRowSelectionManager(data).setSelected(rows, source);
        }
    }

    private void setCount(int count) {
        this.countLabel.setText(count + " " + this.nameOfItems + " selected");
    }

    private void setData(DataBean data) {
        this.datas.clear();
        this.datas.add(data);
    }

    private void setData(Set<DataBean> set) {
        this.datas.clear();
        for (DataBean data : set) {
            this.datas.add(data);
        }
    }
}

