/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import fi.csc.microarray.analyser.AnalysisDescription;
import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.OnDiskAnalysisJobBase;
import fi.csc.microarray.analyser.bsh.BeanShellJobInfo;
import fi.csc.microarray.messaging.JobState;
import org.apache.log4j.Logger;

public class BeanShellJob
extends OnDiskAnalysisJobBase {
    private static final Logger logger = Logger.getLogger(BeanShellJob.class);

    protected void execute() throws Exception {
        this.updateState(JobState.RUNNING, "preparing BeanShell", true);
        BeanShellJobInfo jobInfo = new BeanShellJobInfo();
        jobInfo.workDir = this.jobWorkDir;
        int i = 0;
        for (AnalysisDescription.ParameterDescription param : this.analysis.getParameters()) {
            jobInfo.parameters.put(param.getName(), this.inputMessage.getParameters().get(i));
            ++i;
        }
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("jobInfo", (Object)jobInfo);
            this.updateState(JobState.RUNNING, "running BeanShell", true);
            interpreter.eval(this.analysis.getSourceCode());
        }
        catch (TargetError te) {
            String errorMessage = "An exception occured when running the BeanShell script.";
            logger.warn((Object)errorMessage, (Throwable)te);
            this.outputMessage.setErrorMessage(errorMessage + "\n\n" + te.toString());
            this.updateState(JobState.FAILED, "", true);
        }
        catch (EvalError ee) {
            String errorMessage = "The BeanShell script could not be evaluated.";
            this.outputMessage.setErrorMessage(errorMessage + "\n\n" + ee.toString());
            logger.error((Object)errorMessage, (Throwable)ee);
            this.updateState(JobState.ERROR, "", true);
            throw new AnalysisException(errorMessage);
        }
        this.updateState(JobState.RUNNING, "BeanShell finished succesfully", true);
    }

    protected void cancelRequested() {
    }
}

