/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestInterpretedParsing
extends BaseTest {
    public void testSimpleParse() throws Exception {
        Grammar grammar = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY EOF;\nassign : ID ASSIGN expr SEMI ;\nexpr : INT | FLOAT | ID ;\n");
        Grammar grammar2 = new Grammar();
        grammar2.importTokenVocabulary(grammar);
        grammar2.setFileName("__string");
        grammar2.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("while x { i=1; y=3.42; z=y; }");
        Interpreter interpreter = new Interpreter(grammar2, aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(interpreter);
        commonTokenStream.setTokenTypeChannel(grammar2.getTokenType("WS"), 99);
        Interpreter interpreter2 = new Interpreter(grammar, commonTokenStream);
        ParseTree parseTree = interpreter2.parse("prog");
        String string = parseTree.toStringTree();
        String string2 = "(<grammar p> (prog while x { (assign i = (expr 1) ;) (assign y = (expr 3.42) ;) (assign z = (expr y) ;) } <EOF>))";
        TestInterpretedParsing.assertEquals((String)string2, (String)string);
    }

    public void testMismatchedTokenError() throws Exception {
        Grammar grammar = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY;\nassign : ID ASSIGN expr SEMI ;\nexpr : INT | FLOAT | ID ;\n");
        Grammar grammar2 = new Grammar();
        grammar2.setFileName("__string");
        grammar2.importTokenVocabulary(grammar);
        grammar2.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("while x { i=1 y=3.42; z=y; }");
        Interpreter interpreter = new Interpreter(grammar2, aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(interpreter);
        commonTokenStream.setTokenTypeChannel(grammar2.getTokenType("WS"), 99);
        Interpreter interpreter2 = new Interpreter(grammar, commonTokenStream);
        ParseTree parseTree = interpreter2.parse("prog");
        String string = parseTree.toStringTree();
        String string2 = "(<grammar p> (prog while x { (assign i = (expr 1) MismatchedTokenException(5!=9))))";
        TestInterpretedParsing.assertEquals((String)string2, (String)string);
    }

    public void testMismatchedSetError() throws Exception {
        Grammar grammar = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY;\nassign : ID ASSIGN expr SEMI ;\nexpr : INT | FLOAT | ID ;\n");
        Grammar grammar2 = new Grammar();
        grammar2.importTokenVocabulary(grammar);
        grammar2.setFileName("<string>");
        grammar2.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("while x { i=; y=3.42; z=y; }");
        Interpreter interpreter = new Interpreter(grammar2, aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(interpreter);
        commonTokenStream.setTokenTypeChannel(grammar2.getTokenType("WS"), 99);
        Interpreter interpreter2 = new Interpreter(grammar, commonTokenStream);
        ParseTree parseTree = interpreter2.parse("prog");
        String string = parseTree.toStringTree();
        String string2 = "(<grammar p> (prog while x { (assign i = (expr MismatchedSetException(9!={5,10,11})))))";
        TestInterpretedParsing.assertEquals((String)string2, (String)string);
    }

    public void testNoViableAltError() throws Exception {
        Grammar grammar = new Grammar("parser grammar p;\nprog : WHILE ID LCURLY (assign)* RCURLY;\nassign : ID ASSIGN expr SEMI ;\nexpr : {;}INT | FLOAT | ID ;\n");
        Grammar grammar2 = new Grammar();
        grammar2.importTokenVocabulary(grammar);
        grammar2.setFileName("<string>");
        grammar2.setGrammarContent("lexer grammar t;\nWHILE : 'while';\nLCURLY : '{';\nRCURLY : '}';\nASSIGN : '=';\nSEMI : ';';\nID : ('a'..'z')+ ;\nINT : (DIGIT)+ ;\nFLOAT : (DIGIT)+ '.' (DIGIT)* ;\nfragment DIGIT : '0'..'9';\nWS : (' ')+ ;\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("while x { i=; y=3.42; z=y; }");
        Interpreter interpreter = new Interpreter(grammar2, aNTLRStringStream);
        CommonTokenStream commonTokenStream = new CommonTokenStream(interpreter);
        commonTokenStream.setTokenTypeChannel(grammar2.getTokenType("WS"), 99);
        Interpreter interpreter2 = new Interpreter(grammar, commonTokenStream);
        ParseTree parseTree = interpreter2.parse("prog");
        String string = parseTree.toStringTree();
        String string2 = "(<grammar p> (prog while x { (assign i = (expr NoViableAltException(9!=[4:1: expr : ( INT | FLOAT | ID );])))))";
        TestInterpretedParsing.assertEquals((String)string2, (String)string);
    }
}

