/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import java.math.BigInteger;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BitTwiddling {
    public static final int BYTES_IN_INT = 4;
    public static final int MASK_TO_BYTE = 255;

    public static int[] calculateBitFrequencies(Set<Long> numbers) {
        int[] bitCounts = new int[64];
        for (long value : numbers) {
            for (int b = 0; b < bitCounts.length; ++b) {
                if (!BigInteger.valueOf(value).testBit(b)) continue;
                int n = b;
                bitCounts[n] = bitCounts[n] + 1;
            }
        }
        return bitCounts;
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value & 0xFF), (byte)((value >>= 8) & 0xFF), (byte)((value >>= 8) & 0xFF), (byte)((value >>= 8) & 0xFF)};
        return bytes;
    }

    public static int bytesToInt(byte[] bytes) {
        assert (bytes.length >= 4) : "bytes should have size 4, not " + bytes.length;
        int result = bytes[0] & 0xFF;
        result |= (bytes[1] & 0xFF) << 8;
        result |= (bytes[2] & 0xFF) << 16;
        return result |= (bytes[3] & 0xFF) << 24;
    }
}

