/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans.fs;

import fi.csc.microarray.databeans.DataFolder;
import fi.csc.microarray.databeans.DataFolderBase;
import fi.csc.microarray.databeans.DataItem;
import fi.csc.microarray.databeans.DataItemCreatedEvent;
import fi.csc.microarray.databeans.DataItemRemovedEvent;
import fi.csc.microarray.databeans.fs.FSDataBean;
import fi.csc.microarray.databeans.fs.FSDataManager;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDataFolder
extends DataFolderBase {
    private String name;
    private DataFolder parent = null;
    private List<DataItem> children = new LinkedList<DataItem>();
    private FSDataManager manager;

    public FSDataFolder(FSDataManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    @Override
    public DataFolder getParent() {
        return this.parent;
    }

    private void setParent(FSDataFolder dataFolder) {
        this.parent = dataFolder;
    }

    @Override
    public void addChild(DataItem child) {
        boolean wasConnected;
        boolean bl = wasConnected = child.getParent() != null;
        if (child instanceof FSDataFolder) {
            ((FSDataFolder)child).setParent(this);
        } else if (child instanceof FSDataBean) {
            ((FSDataBean)child).setParent(this);
        } else {
            throw new IllegalArgumentException("cannot add child of type " + child.getClass().getSimpleName());
        }
        this.children.add(child);
        if (!wasConnected) {
            this.manager.dispatchEvent(new DataItemCreatedEvent(child));
        }
    }

    @Override
    public void removeChild(DataItem child) {
        if (child instanceof FSDataFolder) {
            ((FSDataFolder)child).setParent(null);
        } else if (child instanceof FSDataBean) {
            ((FSDataBean)child).setParent(null);
        } else {
            throw new IllegalArgumentException("cannot remove child of type " + child.getClass().getSimpleName());
        }
        this.children.remove(child);
        this.manager.dispatchEvent(new DataItemRemovedEvent(child));
    }

    @Override
    public Iterable<DataItem> getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }
}

