/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.TreeThread;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FileRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FileResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFetcherThread
extends Thread {
    private BlockingQueue<FileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<FileResult> fileResultQueue;
    private TreeThread treeThread;
    private RandomAccessFile raf;
    private ReadInstructions<?> instructions;

    public FileFetcherThread(BlockingQueue<FileRequest> fileRequestQueue, ConcurrentLinkedQueue<FileResult> fileResultQueue, TreeThread treeThread, ReadInstructions<?> instructions) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.treeThread = treeThread;
        this.instructions = instructions;
        this.setDaemon(true);
        try {
            this.raf = new RandomAccessFile(treeThread.getFile(), "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.processFileRequest(this.fileRequestQueue.take());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void processFileRequest(FileRequest fileRequest) throws IOException {
        ByteChunk chunk = new ByteChunk(this.instructions.chunker.getChunkByteLength());
        chunk.readIndex = fileRequest.rowRegion.start;
        this.raf.seek(this.instructions.chunker.getFilePosition(chunk.readIndex));
        chunk.length = this.raf.read(chunk.content);
        fileRequest.status.maybeClearQueue(this.fileResultQueue);
        fileRequest.status.fileRequestCount = this.fileRequestQueue.size();
        this.fileResultQueue.add(new FileResult(fileRequest, chunk, fileRequest.status));
        this.treeThread.notifyTree();
    }

    public long getRowCount() {
        if (this.isAlive()) {
            throw new IllegalStateException("Must be called before the thread is started");
        }
        try {
            return this.instructions.chunker.getReadIndex(this.raf.length());
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

