/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.screen;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.screen.ScreenBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ShowSourceScreen
extends ScreenBase
implements ClientApplication.SourceCodeListener {
    private JFrame frame = null;
    private JTextArea sourceText = new JTextArea();
    private ClientApplication application = Session.getSession().getApplication();
    private JScrollPane scrollPane;

    public JFrame getFrame() {
        String[] opName = new String[]{(String)this.childScreenParameter};
        this.childScreenParameter = null;
        if (opName[0] != null) {
            try {
                this.application.fetchSourceFor(opName, this);
            }
            catch (MicroarrayException e) {
                this.application.reportException(e);
            }
        } else if (this.frame != null) {
            return this.frame;
        }
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = new JFrame();
        this.frame.setContentPane(this.getContentPane());
        this.frame.setTitle("Source Code");
        return this.frame;
    }

    private JPanel getContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.sourceText.setText("Please wait while loading source code...");
        this.sourceText.setEditable(false);
        this.sourceText.setFont(VisualConstants.MONOSPACED_FONT);
        contentPane.setPreferredSize(new Dimension(800, 400));
        this.scrollPane = new JScrollPane(this.sourceText);
        contentPane.add((Component)this.scrollPane, "Center");
        return contentPane;
    }

    public boolean hasFrame() {
        return this.frame != null;
    }

    public void updateSourceCodeAt(int index, String sourceCode) {
        this.sourceText.setText(sourceCode);
        this.sourceText.setCaretPosition(0);
    }
}

