/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.bugs.MessageSender;
import org.apache.activemq.bugs.Receiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionNotStartedErrorTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TransactionNotStartedErrorTest.class);
    private static int counter = 500;
    private static int hectorToHaloCtr;
    private static int xenaToHaloCtr;
    private static int troyToHaloCtr;
    private static int haloToHectorCtr;
    private static int haloToXenaCtr;
    private static int haloToTroyCtr;
    private String hectorToHalo = "hectorToHalo";
    private String xenaToHalo = "xenaToHalo";
    private String troyToHalo = "troyToHalo";
    private String haloToHector = "haloToHector";
    private String haloToXena = "haloToXena";
    private String haloToTroy = "haloToTroy";
    private BrokerService broker;
    private Connection hectorConnection;
    private Connection xenaConnection;
    private Connection troyConnection;
    private Connection haloConnection;
    private final Object lock = new Object();

    public Connection createConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        return factory.createConnection();
    }

    public Session createSession(Connection connection, boolean transacted) throws JMSException {
        return connection.createSession(transacted, 1);
    }

    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.addConnector("tcp://localhost:61616").setName("Default");
        this.broker.start();
        LOG.info((Object)"Starting broker..");
    }

    public void tearDown() throws Exception {
        this.hectorConnection.close();
        this.xenaConnection.close();
        this.troyConnection.close();
        this.haloConnection.close();
        this.broker.stop();
    }

    public void testTransactionNotStartedError() throws Exception {
        this.startBroker();
        this.hectorConnection = this.createConnection();
        Thread hectorThread = this.buildProducer(this.hectorConnection, this.hectorToHalo);
        Receiver hHectorReceiver = new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(String s) throws Exception {
                haloToHectorCtr++;
                if (haloToHectorCtr >= counter) {
                    Object object = TransactionNotStartedErrorTest.this.lock;
                    synchronized (object) {
                        TransactionNotStartedErrorTest.this.lock.notifyAll();
                    }
                }
            }
        };
        this.buildReceiver(this.hectorConnection, this.haloToHector, false, hHectorReceiver);
        this.troyConnection = this.createConnection();
        Thread troyThread = this.buildProducer(this.troyConnection, this.troyToHalo);
        Receiver hTroyReceiver = new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(String s) throws Exception {
                haloToTroyCtr++;
                if (haloToTroyCtr >= counter) {
                    Object object = TransactionNotStartedErrorTest.this.lock;
                    synchronized (object) {
                        TransactionNotStartedErrorTest.this.lock.notifyAll();
                    }
                }
            }
        };
        this.buildReceiver(this.hectorConnection, this.haloToTroy, false, hTroyReceiver);
        this.xenaConnection = this.createConnection();
        Thread xenaThread = this.buildProducer(this.xenaConnection, this.xenaToHalo);
        Receiver hXenaReceiver = new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(String s) throws Exception {
                haloToXenaCtr++;
                if (haloToXenaCtr >= counter) {
                    Object object = TransactionNotStartedErrorTest.this.lock;
                    synchronized (object) {
                        TransactionNotStartedErrorTest.this.lock.notifyAll();
                    }
                }
            }
        };
        this.buildReceiver(this.xenaConnection, this.haloToXena, false, hXenaReceiver);
        this.haloConnection = this.createConnection();
        final MessageSender hectorSender = this.buildTransactionalProducer(this.haloToHector, this.haloConnection);
        final MessageSender troySender = this.buildTransactionalProducer(this.haloToTroy, this.haloConnection);
        final MessageSender xenaSender = this.buildTransactionalProducer(this.haloToXena, this.haloConnection);
        Receiver hectorReceiver = new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(String s) throws Exception {
                hectorToHaloCtr++;
                troySender.send("halo to troy because of hector");
                if (hectorToHaloCtr >= counter) {
                    Object object = TransactionNotStartedErrorTest.this.lock;
                    synchronized (object) {
                        TransactionNotStartedErrorTest.this.lock.notifyAll();
                    }
                }
            }
        };
        Receiver xenaReceiver = new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(String s) throws Exception {
                xenaToHaloCtr++;
                hectorSender.send("halo to hector because of xena");
                if (xenaToHaloCtr >= counter) {
                    Object object = TransactionNotStartedErrorTest.this.lock;
                    synchronized (object) {
                        TransactionNotStartedErrorTest.this.lock.notifyAll();
                    }
                }
            }
        };
        Receiver troyReceiver = new Receiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void receive(String s) throws Exception {
                troyToHaloCtr++;
                xenaSender.send("halo to xena because of troy");
                if (troyToHaloCtr >= counter) {
                    Object object = TransactionNotStartedErrorTest.this.lock;
                    synchronized (object) {
                        TransactionNotStartedErrorTest.this.lock.notifyAll();
                    }
                }
            }
        };
        this.buildReceiver(this.haloConnection, this.hectorToHalo, true, hectorReceiver);
        this.buildReceiver(this.haloConnection, this.xenaToHalo, true, xenaReceiver);
        this.buildReceiver(this.haloConnection, this.troyToHalo, true, troyReceiver);
        this.haloConnection.start();
        this.troyConnection.start();
        troyThread.start();
        this.xenaConnection.start();
        xenaThread.start();
        this.hectorConnection.start();
        hectorThread.start();
        this.waitForMessagesToBeDelivered();
        TransactionNotStartedErrorTest.assertEquals((int)hectorToHaloCtr, (int)counter);
        LOG.info((Object)("hectorToHalo received " + hectorToHaloCtr + " messages"));
        TransactionNotStartedErrorTest.assertEquals((int)xenaToHaloCtr, (int)counter);
        LOG.info((Object)("xenaToHalo received " + xenaToHaloCtr + " messages"));
        TransactionNotStartedErrorTest.assertEquals((int)troyToHaloCtr, (int)counter);
        LOG.info((Object)("troyToHalo received " + troyToHaloCtr + " messages"));
        TransactionNotStartedErrorTest.assertEquals((int)haloToHectorCtr, (int)counter);
        LOG.info((Object)("haloToHector received " + haloToHectorCtr + " messages"));
        TransactionNotStartedErrorTest.assertEquals((int)haloToXenaCtr, (int)counter);
        LOG.info((Object)("haloToXena received " + haloToXenaCtr + " messages"));
        TransactionNotStartedErrorTest.assertEquals((int)haloToTroyCtr, (int)counter);
        LOG.info((Object)("haloToTroy received " + haloToTroyCtr + " messages"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = (long)(counter * 3000);
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            boolean hasMessages = true;
            while (hasMessages && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)e);
                }
                hasMessages = hectorToHaloCtr < counter || xenaToHaloCtr < counter || troyToHaloCtr < counter || haloToHectorCtr < counter || haloToXenaCtr < counter || haloToTroyCtr < counter;
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    public MessageSender buildTransactionalProducer(String queueName, Connection connection) throws Exception {
        return new MessageSender(queueName, connection, true);
    }

    public Thread buildProducer(Connection connection, final String queueName) throws Exception {
        final Session session = connection.createSession(false, 1);
        final MessageSender producer = new MessageSender(queueName, connection, false);
        Thread thread = new Thread(){

            public synchronized void run() {
                for (int i = 0; i < counter; ++i) {
                    try {
                        producer.send(queueName);
                        if (!session.getTransacted()) continue;
                        session.commit();
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("on " + queueName + " send", e);
                    }
                }
            }
        };
        return thread;
    }

    public void buildReceiver(Connection connection, String queueName, boolean transacted, final Receiver receiver) throws Exception {
        final Session session = transacted ? connection.createSession(true, 0) : connection.createSession(false, 1);
        MessageConsumer inputMessageConsumer = session.createConsumer((Destination)session.createQueue(queueName));
        MessageListener messageListener = new MessageListener(){

            public void onMessage(Message message) {
                try {
                    ObjectMessage objectMessage = (ObjectMessage)message;
                    String s = (String)((Object)objectMessage.getObject());
                    receiver.receive(s);
                    if (session.getTransacted()) {
                        session.commit();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        inputMessageConsumer.setMessageListener(messageListener);
    }
}

