/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;

public class ReconnectWithJMXEnabledTest
extends EmbeddedBrokerTestSupport {
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;

    public void testTestUseConnectionCloseBrokerThenRestartInSameJVM() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        this.connection.close();
        this.broker.stop();
        this.broker = this.createBroker();
        this.startBroker();
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void useConnection(Connection connection) throws Exception {
        connection.setClientID("foo");
        connection.start();
        Session session = connection.createSession(this.transacted, this.authMode);
        Destination destination = this.createDestination();
        MessageConsumer consumer = session.createConsumer(destination);
        MessageProducer producer = session.createProducer(destination);
        TextMessage message = session.createTextMessage("Hello World");
        producer.send((Message)message);
        Thread.sleep(1000L);
    }
}

