/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.broker.region.RegionBroker;

public class TempDestLoadTest
extends EmbeddedBrokerTestSupport {
    protected int consumerCounter;
    private Connection connection;
    private Session session;
    private static final int MESSAGE_COUNT = 2000;

    public void testLoadTempAdvisoryQueues() throws Exception {
        for (int i = 0; i < 2000; ++i) {
            TemporaryQueue tempQueue = this.session.createTemporaryQueue();
            MessageConsumer consumer = this.session.createConsumer((Destination)tempQueue);
            MessageProducer producer = this.session.createProducer((Destination)tempQueue);
            consumer.close();
            producer.close();
            tempQueue.delete();
        }
        AdvisoryBroker ab = (AdvisoryBroker)this.broker.getBroker().getAdaptor(AdvisoryBroker.class);
        TempDestLoadTest.assertTrue((ab.getAdvisoryDestinations().size() == 0 ? 1 : 0) != 0);
        TempDestLoadTest.assertTrue((ab.getAdvisoryConsumers().size() == 0 ? 1 : 0) != 0);
        TempDestLoadTest.assertTrue((ab.getAdvisoryProducers().size() == 0 ? 1 : 0) != 0);
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        TempDestLoadTest.assertTrue((rb.getDestinationMap().size() == 2 ? 1 : 0) != 0);
    }

    public void testLoadTempAdvisoryTopics() throws Exception {
        for (int i = 0; i < 2000; ++i) {
            TemporaryTopic tempTopic = this.session.createTemporaryTopic();
            MessageConsumer consumer = this.session.createConsumer((Destination)tempTopic);
            MessageProducer producer = this.session.createProducer((Destination)tempTopic);
            consumer.close();
            producer.close();
            tempTopic.delete();
        }
        AdvisoryBroker ab = (AdvisoryBroker)this.broker.getBroker().getAdaptor(AdvisoryBroker.class);
        TempDestLoadTest.assertTrue((ab.getAdvisoryDestinations().size() == 0 ? 1 : 0) != 0);
        TempDestLoadTest.assertTrue((ab.getAdvisoryConsumers().size() == 0 ? 1 : 0) != 0);
        TempDestLoadTest.assertTrue((ab.getAdvisoryProducers().size() == 0 ? 1 : 0) != 0);
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        TempDestLoadTest.assertTrue((rb.getDestinationMap().size() == 2 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 0);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

