/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;

public class QueueConsumerPriorityTest
extends TestCase {
    private static final String VM_BROKER_URL = "vm://localhost?broker.persistent=false&broker.useJmx=true";

    public QueueConsumerPriorityTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private Connection createConnection(boolean start) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(VM_BROKER_URL);
        Connection conn = cf.createConnection();
        if (start) {
            conn.start();
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueueConsumerPriority() throws JMSException, InterruptedException {
        Connection conn = this.createConnection(true);
        Session consumerLowPriority = null;
        Session consumerHighPriority = null;
        Session senderSession = null;
        try {
            consumerLowPriority = conn.createSession(false, 1);
            consumerHighPriority = conn.createSession(false, 1);
            senderSession = conn.createSession(false, 1);
            String queueName = ((Object)((Object)this)).getClass().getName();
            ActiveMQQueue low = new ActiveMQQueue(queueName + "?consumer.priority=1");
            MessageConsumer lowConsumer = consumerLowPriority.createConsumer((Destination)low);
            ActiveMQQueue high = new ActiveMQQueue(queueName + "?consumer.priority=2");
            MessageConsumer highConsumer = consumerLowPriority.createConsumer((Destination)high);
            ActiveMQQueue senderQueue = new ActiveMQQueue(queueName);
            MessageProducer producer = senderSession.createProducer((Destination)senderQueue);
            TextMessage msg = senderSession.createTextMessage("test");
            for (int i = 0; i < 10000; ++i) {
                producer.send((Message)msg);
                Assert.assertNotNull((Object)highConsumer.receive(100L));
            }
            Assert.assertNull((Object)lowConsumer.receive(500L));
        }
        finally {
            conn.close();
        }
    }
}

