/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.endpoint;

import java.util.Map;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jms.listener.endpoint.JmsActivationSpecConfig;
import org.springframework.jms.listener.endpoint.JmsActivationSpecFactory;
import org.springframework.jms.support.destination.DestinationResolutionException;
import org.springframework.jms.support.destination.DestinationResolver;

public class StandardJmsActivationSpecFactory
implements JmsActivationSpecFactory {
    private Class activationSpecClass;
    private Properties defaultProperties;
    private DestinationResolver destinationResolver;

    public void setActivationSpecClass(Class activationSpecClass) {
        this.activationSpecClass = activationSpecClass;
    }

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public ActivationSpec createActivationSpec(ResourceAdapter adapter, JmsActivationSpecConfig config) {
        Class activationSpecClassToUse = this.activationSpecClass;
        if (activationSpecClassToUse == null && (activationSpecClassToUse = this.determineActivationSpecClass(adapter)) == null) {
            throw new IllegalStateException("Property 'activationSpecClass' is required");
        }
        BeanWrapperImpl bw = new BeanWrapperImpl(activationSpecClassToUse);
        if (this.defaultProperties != null) {
            bw.setPropertyValues((Map)this.defaultProperties);
        }
        this.populateActivationSpecProperties((BeanWrapper)bw, config);
        return (ActivationSpec)bw.getWrappedInstance();
    }

    protected Class determineActivationSpecClass(ResourceAdapter adapter) {
        return null;
    }

    protected void populateActivationSpecProperties(BeanWrapper bw, JmsActivationSpecConfig config) {
        String destinationName = config.getDestinationName();
        boolean pubSubDomain = config.isPubSubDomain();
        String destination = destinationName;
        if (this.destinationResolver != null) {
            try {
                destination = this.destinationResolver.resolveDestinationName(null, destinationName, pubSubDomain);
            }
            catch (JMSException ex) {
                throw new DestinationResolutionException("Cannot resolve destination name [" + destinationName + "]", ex);
            }
        }
        bw.setPropertyValue("destination", (Object)destination);
        bw.setPropertyValue("destinationType", (Object)(pubSubDomain ? Topic.class.getName() : Queue.class.getName()));
        bw.setPropertyValue("subscriptionDurability", (Object)(config.isSubscriptionDurable() ? "Durable" : "NonDurable"));
        if (config.getDurableSubscriptionName() != null) {
            bw.setPropertyValue("subscriptionName", (Object)config.getDurableSubscriptionName());
        }
        if (config.getClientId() != null) {
            bw.setPropertyValue("clientId", (Object)config.getClientId());
        }
        if (config.getMessageSelector() != null) {
            bw.setPropertyValue("messageSelector", (Object)config.getMessageSelector());
        }
        this.applyAcknowledgeMode(bw, config.getAcknowledgeMode());
    }

    protected void applyAcknowledgeMode(BeanWrapper bw, int ackMode) {
        if (ackMode == 0) {
            throw new IllegalArgumentException("No support for SESSION_TRANSACTED: Only \"Auto-acknowledge\" and \"Dups-ok-acknowledge\" supported in standard JCA 1.5");
        }
        if (ackMode == 2) {
            throw new IllegalArgumentException("No support for CLIENT_ACKNOWLEDGE: Only \"Auto-acknowledge\" and \"Dups-ok-acknowledge\" supported in standard JCA 1.5");
        }
        bw.setPropertyValue("acknowledgeMode", (Object)(ackMode == 3 ? "Dups-ok-acknowledge" : "Auto-acknowledge"));
    }
}

