/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.config;

import fi.csc.microarray.config.ConfigurationLoader;

public class ConfigurationEntry {
    private static final String PROPERTY_REFERENCE_POSTFIX = "}";
    private static final String PROPERTY_REFERENCE_PREFIX = "${";
    private String[] stringValues;
    private int[] intValues;
    private boolean[] booleanValues;
    private Type type;
    private String name;
    private boolean mustBeSet = false;

    public ConfigurationEntry(String name, String typeName) {
        this.type = Type.fromName(typeName);
        this.name = name;
    }

    public void setValue(String[] values) throws ConfigurationLoader.IllegalConfigurationException {
        int i;
        if (this.type.isSingle() && values.length > 1) {
            throw new ConfigurationLoader.IllegalConfigurationException(this.name + " accepts only single value");
        }
        for (i = 0; i < values.length; ++i) {
            if (!values[i].startsWith(PROPERTY_REFERENCE_PREFIX)) continue;
            String[] split = values[i].split(PROPERTY_REFERENCE_POSTFIX);
            String systemProperty = System.getProperty(split[0].substring(2));
            values[i] = systemProperty + split[1];
        }
        switch (this.type) {
            case STRING: 
            case STRINGS: {
                this.stringValues = values;
                break;
            }
            case INT: 
            case INTS: {
                this.intValues = new int[values.length];
                for (i = 0; i < values.length; ++i) {
                    try {
                        this.intValues[i] = Integer.parseInt(values[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new ConfigurationLoader.IllegalConfigurationException("illegal integer values " + values[i] + " for setting " + this.name);
                    }
                }
                break;
            }
            case BOOLEAN: 
            case BOOLEANS: {
                this.booleanValues = new boolean[values.length];
                for (i = 0; i < values.length; ++i) {
                    if (Boolean.TRUE.toString().equals(values[i].toLowerCase())) {
                        this.booleanValues[i] = true;
                        continue;
                    }
                    if (Boolean.FALSE.toString().equals(values[i].toLowerCase())) {
                        this.booleanValues[i] = false;
                        continue;
                    }
                    throw new ConfigurationLoader.IllegalConfigurationException("illegal boolean value " + values[i] + " for setting " + this.name);
                }
                break;
            }
            default: {
                throw new RuntimeException("unknown type " + (Object)((Object)this.type));
            }
        }
        this.mustBeSet = false;
    }

    public String getString() {
        this.checkType(Type.STRING);
        if (this.stringValues.length > 1) {
            throw new IllegalArgumentException("multiple values found for " + this.name);
        }
        return this.stringValues[0];
    }

    public int getInt() {
        this.checkType(Type.INT);
        if (this.intValues.length > 1) {
            throw new IllegalArgumentException("multiple values found for " + this.name);
        }
        return this.intValues[0];
    }

    public boolean getBoolean() {
        this.checkType(Type.BOOLEAN);
        if (this.booleanValues.length > 1) {
            throw new IllegalArgumentException("multiple values found for " + this.name);
        }
        return this.booleanValues[0];
    }

    public String[] getStrings() {
        this.checkType(Type.STRINGS);
        return this.stringValues;
    }

    public int[] getInts() {
        this.checkType(Type.INTS);
        return this.intValues;
    }

    public boolean[] getBooleans() {
        this.checkType(Type.BOOLEANS);
        return this.booleanValues;
    }

    private void checkType(Type suggested) {
        if (this.type != suggested) {
            throw new IllegalArgumentException(this.name + " has type " + (Object)((Object)this.type) + ", not " + (Object)((Object)suggested));
        }
    }

    public void setMustBeSet(boolean mustBeSet) {
        this.mustBeSet = mustBeSet;
    }

    public boolean mustBeSet() {
        return this.mustBeSet;
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        STRING,
        INT,
        BOOLEAN,
        STRINGS,
        INTS,
        BOOLEANS;


        public boolean isSingle() {
            return this == STRING || this == INT || this == BOOLEAN;
        }

        public static Type fromName(String typeName) {
            return Type.valueOf(typeName.toUpperCase());
        }
    }
}

