/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;

public class LegacyFrameTranslator
implements FrameTranslator {
    public ActiveMQMessage convertFrame(ProtocolConverter converter, StompFrame command) throws JMSException, ProtocolException {
        ActiveMQMessage msg;
        Map<String, String> headers = command.getHeaders();
        if (headers.containsKey("content-length")) {
            headers.remove("content-length");
            ActiveMQBytesMessage bm = new ActiveMQBytesMessage();
            bm.writeBytes(command.getContent());
            msg = bm;
        } else {
            ActiveMQTextMessage text = new ActiveMQTextMessage();
            try {
                text.setText(new String(command.getContent(), "UTF-8"));
            }
            catch (Throwable e) {
                throw new ProtocolException("Text could not bet set: " + e, false, e);
            }
            msg = text;
        }
        FrameTranslator.Helper.copyStandardHeadersFromFrameToMessage(converter, command, msg, this);
        return msg;
    }

    public StompFrame convertMessage(ProtocolConverter converter, ActiveMQMessage message) throws IOException, JMSException {
        StompFrame command = new StompFrame();
        command.setAction("MESSAGE");
        HashMap<String, String> headers = new HashMap<String, String>(25);
        command.setHeaders(headers);
        FrameTranslator.Helper.copyStandardHeadersFromMessageToFrame(converter, message, command, this);
        if (message.getDataStructureType() == 28) {
            ActiveMQTextMessage msg = (ActiveMQTextMessage)message.copy();
            command.setContent(msg.getText().getBytes("UTF-8"));
        } else if (message.getDataStructureType() == 24) {
            ActiveMQBytesMessage msg = (ActiveMQBytesMessage)message.copy();
            msg.setReadOnlyBody(true);
            byte[] data = new byte[(int)msg.getBodyLength()];
            msg.readBytes(data);
            headers.put("content-length", "" + data.length);
            command.setContent(data);
        }
        return command;
    }

    public String convertDestination(ProtocolConverter converter, Destination d) {
        if (d == null) {
            return null;
        }
        ActiveMQDestination activeMQDestination = (ActiveMQDestination)d;
        String physicalName = activeMQDestination.getPhysicalName();
        String rc = converter.getCreatedTempDestinationName(activeMQDestination);
        if (rc != null) {
            return rc;
        }
        StringBuffer buffer = new StringBuffer();
        if (activeMQDestination.isQueue()) {
            if (activeMQDestination.isTemporary()) {
                buffer.append("/remote-temp-queue/");
            } else {
                buffer.append("/queue/");
            }
        } else if (activeMQDestination.isTemporary()) {
            buffer.append("/remote-temp-topic/");
        } else {
            buffer.append("/topic/");
        }
        buffer.append(physicalName);
        return buffer.toString();
    }

    public ActiveMQDestination convertDestination(ProtocolConverter converter, String name) throws ProtocolException {
        if (name == null) {
            return null;
        }
        if (name.startsWith("/queue/")) {
            String qName = name.substring("/queue/".length(), name.length());
            return ActiveMQDestination.createDestination(qName, (byte)1);
        }
        if (name.startsWith("/topic/")) {
            String tName = name.substring("/topic/".length(), name.length());
            return ActiveMQDestination.createDestination(tName, (byte)2);
        }
        if (name.startsWith("/remote-temp-queue/")) {
            String tName = name.substring("/remote-temp-queue/".length(), name.length());
            return ActiveMQDestination.createDestination(tName, (byte)5);
        }
        if (name.startsWith("/remote-temp-topic/")) {
            String tName = name.substring("/remote-temp-topic/".length(), name.length());
            return ActiveMQDestination.createDestination(tName, (byte)6);
        }
        if (name.startsWith("/temp-queue/")) {
            return converter.createTempQueue(name);
        }
        if (name.startsWith("/temp-topic/")) {
            return converter.createTempTopic(name);
        }
        throw new ProtocolException("Illegal destination name: [" + name + "] -- ActiveMQ STOMP destinations " + "must begine with one of: /queue/ /topic/ /temp-queue/ /temp-topic/");
    }
}

