/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test.retroactive;

import java.net.URI;
import java.util.Date;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.MessageIdList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetroactiveConsumerWithMessageQueryTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(RetroactiveConsumerWithMessageQueryTest.class);
    protected int messageCount = 20;
    protected Connection connection;
    protected Session session;

    public void testConsumeAndReceiveInitialQueryBeforeUpdates() throws Exception {
        this.connection = this.createConnection();
        this.session = this.connection.createSession(false, 1);
        this.connection.start();
        MessageConsumer consumer = this.session.createConsumer(this.destination);
        MessageIdList listener = new MessageIdList();
        listener.setVerbose(true);
        consumer.setMessageListener(listener);
        MessageProducer producer = this.session.createProducer(this.destination);
        int updateMessageCount = this.messageCount - 10;
        for (int i = 0; i < updateMessageCount; ++i) {
            TextMessage message = this.session.createTextMessage("Update Message: " + i + " sent at: " + new Date());
            producer.send(message);
        }
        producer.close();
        LOG.info("Sent: " + updateMessageCount + " update messages");
        listener.assertMessagesReceived(this.messageCount);
    }

    protected void setUp() throws Exception {
        this.useTopic = true;
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory answer = new ActiveMQConnectionFactory(this.bindAddress);
        answer.setUseRetroactiveConsumer(true);
        return answer;
    }

    protected BrokerService createBroker() throws Exception {
        String uri = this.getBrokerXml();
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker(new URI("xbean:" + uri));
    }

    protected void startBroker() throws Exception {
    }

    protected String getBrokerXml() {
        return "org/apache/activemq/test/retroactive/activemq-message-query.xml";
    }
}

