/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionPerMessageTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(ConnectionPerMessageTest.class);
    private static final int COUNT = 20000;
    protected String bindAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionPerMessage() throws Exception {
        String topicName = "test.topic";
        LOG.info("Initializing pooled connection factory for JMS to URL: " + this.bindAddress);
        ActiveMQConnectionFactory normalFactory = new ActiveMQConnectionFactory();
        normalFactory.setBrokerURL(this.bindAddress);
        for (int i = 0; i < 20000; ++i) {
            if (i % 1000 == 0) {
                LOG.info(i);
            }
            Connection conn = null;
            try {
                conn = normalFactory.createConnection();
                Session session = conn.createSession(false, 1);
                Topic topic = session.createTopic("test.topic");
                MessageProducer producer = session.createProducer(topic);
                producer.setDeliveryMode(2);
                MapMessage m = session.createMapMessage();
                m.setInt("hey", i);
                producer.send(m);
                continue;
            }
            catch (JMSException e) {
                LOG.warn(e.getMessage(), e);
                continue;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (JMSException e) {
                        LOG.warn(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        super.setUp();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected boolean isPersistent() {
        return true;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

