/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TopicSubscriptionTest;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.StrictOrderDispatchPolicy;
import org.apache.activemq.util.MessageIdList;

public class StrictOrderDispatchPolicyTest
extends TopicSubscriptionTest {
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy(new StrictOrderDispatchPolicy());
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesOnePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesOnePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesLargePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesLargePrefetch();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testOneProducerManyConsumersFewMessages() throws Exception {
        super.testOneProducerManyConsumersFewMessages();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testOneProducerManyConsumersManyMessages() throws Exception {
        super.testOneProducerManyConsumersManyMessages();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testManyProducersOneConsumer() throws Exception {
        super.testManyProducersOneConsumer();
        this.assertReceivedMessagesAreOrdered();
    }

    public void testManyProducersManyConsumers() throws Exception {
        super.testManyProducersManyConsumers();
        this.assertReceivedMessagesAreOrdered();
    }

    public void assertReceivedMessagesAreOrdered() throws Exception {
        if (this.consumers.size() <= 1) {
            return;
        }
        Iterator i = this.consumers.keySet().iterator();
        MessageIdList messageOrder = (MessageIdList)this.consumers.get(i.next());
        while (i.hasNext()) {
            MessageIdList messageIdList = (MessageIdList)this.consumers.get(i.next());
            StrictOrderDispatchPolicyTest.assertTrue((String)"Messages are not ordered.", (boolean)messageOrder.equals(messageIdList));
        }
    }
}

