/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQPrefetchPolicy
implements Serializable {
    private static final Log LOG = LogFactory.getLog(ActiveMQPrefetchPolicy.class);
    private static final int MAX_PREFETCH_SIZE = 32766;
    private int queuePrefetch = 1000;
    private int queueBrowserPrefetch = 500;
    private int topicPrefetch = 32766;
    private int durableTopicPrefetch = 100;
    private int optimizeDurableTopicPrefetch = 1000;
    private int inputStreamPrefetch = 100;
    private int maximumPendingMessageLimit;

    public int getDurableTopicPrefetch() {
        return this.durableTopicPrefetch;
    }

    public void setDurableTopicPrefetch(int durableTopicPrefetch) {
        this.durableTopicPrefetch = this.getMaxPrefetchLimit(durableTopicPrefetch);
    }

    public int getQueuePrefetch() {
        return this.queuePrefetch;
    }

    public void setQueuePrefetch(int queuePrefetch) {
        this.queuePrefetch = this.getMaxPrefetchLimit(queuePrefetch);
    }

    public int getQueueBrowserPrefetch() {
        return this.queueBrowserPrefetch;
    }

    public void setQueueBrowserPrefetch(int queueBrowserPrefetch) {
        this.queueBrowserPrefetch = this.getMaxPrefetchLimit(queueBrowserPrefetch);
    }

    public int getTopicPrefetch() {
        return this.topicPrefetch;
    }

    public void setTopicPrefetch(int topicPrefetch) {
        this.topicPrefetch = this.getMaxPrefetchLimit(topicPrefetch);
    }

    public int getOptimizeDurableTopicPrefetch() {
        return this.optimizeDurableTopicPrefetch;
    }

    public void setOptimizeDurableTopicPrefetch(int optimizeAcknowledgePrefetch) {
        this.optimizeDurableTopicPrefetch = optimizeAcknowledgePrefetch;
    }

    public int getMaximumPendingMessageLimit() {
        return this.maximumPendingMessageLimit;
    }

    public void setMaximumPendingMessageLimit(int maximumPendingMessageLimit) {
        this.maximumPendingMessageLimit = maximumPendingMessageLimit;
    }

    private int getMaxPrefetchLimit(int value) {
        int result = Math.min(value, 32766);
        if (result < value) {
            LOG.warn("maximum prefetch limit has been reset from " + value + " to " + 32766);
        }
        return result;
    }

    public void setAll(int i) {
        this.durableTopicPrefetch = i;
        this.queueBrowserPrefetch = i;
        this.queuePrefetch = i;
        this.topicPrefetch = i;
        this.inputStreamPrefetch = 1;
        this.optimizeDurableTopicPrefetch = i;
    }

    public int getInputStreamPrefetch() {
        return this.inputStreamPrefetch;
    }

    public void setInputStreamPrefetch(int inputStreamPrefetch) {
        this.inputStreamPrefetch = this.getMaxPrefetchLimit(inputStreamPrefetch);
    }
}

