/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splitter
extends MulticastProcessor
implements Processor {
    public static final String SPLIT_SIZE = "org.apache.camel.splitSize";
    public static final String SPLIT_COUNTER = "org.apache.camel.splitCounter";
    private final Expression expression;

    public Splitter(Expression expression, Processor destination, AggregationStrategy aggregationStrategy) {
        this(expression, destination, aggregationStrategy, false, null);
    }

    public Splitter(Expression expression, Processor destination, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ThreadPoolExecutor threadPoolExecutor) {
        super(Collections.singleton(destination), aggregationStrategy, parallelProcessing, threadPoolExecutor);
        this.expression = expression;
        ObjectHelper.notNull(expression, "expression");
        ObjectHelper.notNull(destination, "destination");
    }

    @Override
    public String toString() {
        return "Splitter[on: " + this.expression + " to: " + this.getProcessors().iterator().next() + " aggregate: " + this.getAggregationStrategy() + "]";
    }

    @Override
    protected List<MulticastProcessor.ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) {
        Object value = this.expression.evaluate(exchange);
        Integer collectionSize = CollectionHelper.size(value);
        ArrayList<MulticastProcessor.ProcessorExchangePair> result = collectionSize != null ? new ArrayList(collectionSize) : new ArrayList<MulticastProcessor.ProcessorExchangePair>();
        Iterator iter = ObjectConverter.iterator(value);
        while (iter.hasNext()) {
            Object part = iter.next();
            Exchange newExchange = exchange.copy();
            Message in = newExchange.getIn();
            in.setBody(part);
            result.add(new MulticastProcessor.ProcessorExchangePair(this.getProcessors().iterator().next(), newExchange));
        }
        return result;
    }

    @Override
    protected void updateNewExchange(Exchange exchange, int i, List<MulticastProcessor.ProcessorExchangePair> allPairs) {
        exchange.getIn().setHeader(SPLIT_COUNTER, i);
        exchange.getIn().setHeader(SPLIT_SIZE, allPairs.size());
    }
}

