/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.model.FromType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RouteType;
import org.apache.camel.processor.Interceptor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.ProceedProcessor;
import org.apache.camel.processor.UnitOfWorkProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteContext {
    private RouteType route;
    private FromType from;
    private Collection<Route> routes;
    private Endpoint<? extends Exchange> endpoint;
    private List<Processor> eventDrivenProcessors = new ArrayList<Processor>();
    private Interceptor lastInterceptor;
    private CamelContext camelContext;

    public RouteContext(RouteType route, FromType from, Collection<Route> routes) {
        this.route = route;
        this.from = from;
        this.routes = routes;
    }

    public RouteContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.routes = new ArrayList<Route>();
        this.route = new RouteType("temporary");
    }

    public Endpoint<? extends Exchange> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = this.from.resolveEndpoint(this);
        }
        return this.endpoint;
    }

    public FromType getFrom() {
        return this.from;
    }

    public RouteType getRoute() {
        return this.route;
    }

    public CamelContext getCamelContext() {
        if (this.camelContext == null) {
            this.camelContext = this.getRoute().getCamelContext();
        }
        return this.camelContext;
    }

    public Processor createProcessor(ProcessorType node) throws Exception {
        return node.createOutputsProcessor(this);
    }

    public Endpoint<? extends Exchange> resolveEndpoint(String uri) {
        return this.route.resolveEndpoint(uri);
    }

    public Endpoint<? extends Exchange> resolveEndpoint(String uri, String ref) {
        Endpoint endpoint = null;
        if (uri != null && (endpoint = this.resolveEndpoint(uri)) == null) {
            throw new NoSuchEndpointException(uri);
        }
        if (ref != null && (endpoint = this.lookup(ref, Endpoint.class)) == null) {
            throw new NoSuchEndpointException("ref:" + ref);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Either 'uri' or 'ref' must be specified on: " + this);
        }
        return endpoint;
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.getCamelContext().getRegistry().lookup(name, type);
    }

    public void commit() {
        if (!this.eventDrivenProcessors.isEmpty()) {
            Processor processor = Pipeline.newInstance(this.eventDrivenProcessors);
            AsyncProcessor asyncProcessor = AsyncProcessorTypeConverter.convert(processor);
            UnitOfWorkProcessor unitOfWorkProcessor = new UnitOfWorkProcessor(asyncProcessor);
            EventDrivenConsumerRoute edcr = new EventDrivenConsumerRoute((Endpoint)this.getEndpoint(), unitOfWorkProcessor);
            edcr.getProperties().put("parent", Integer.toHexString(this.route.hashCode()));
            if (this.route.getGroup() != null) {
                edcr.getProperties().put("group", this.route.getGroup());
            }
            this.routes.add(edcr);
        }
    }

    public void addEventDrivenProcessor(Processor processor) {
        this.eventDrivenProcessors.add(processor);
    }

    public void intercept(Interceptor interceptor) {
        this.lastInterceptor = interceptor;
    }

    public Processor createProceedProcessor() {
        if (this.lastInterceptor == null) {
            throw new IllegalArgumentException("Cannot proceed() from outside of an interceptor!");
        }
        return new ProceedProcessor(this.lastInterceptor);
    }
}

