/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetConsumer
extends DefaultConsumer<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(DataSetConsumer.class);
    private DataSetEndpoint endpoint;

    public DataSetConsumer(DataSetEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.getExecutorService().execute(new Runnable(){

            public void run() {
                DataSetConsumer.this.sendMessages();
            }
        });
    }

    protected void sendMessages() {
        try {
            DataSet dataSet = this.endpoint.getDataSet();
            for (long i = 0L; i < dataSet.getSize(); ++i) {
                Exchange exchange = this.endpoint.createExchange(i);
                this.getProcessor().process(exchange);
                long delay = this.endpoint.getProduceDelay();
                if (delay <= 0L) continue;
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)e);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }
}

