/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerate;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;

public abstract class GenericScanController
extends GenericController
implements ScanManager {
    public static final int SCAN_INIT = 1;
    public static final int SCAN_INPROGRESS = 2;
    public static final int SCAN_DONE = 3;
    public static final int SCAN_HOLD_INIT = 4;
    public static final int SCAN_HOLD_INPROGRESS = 5;
    private FormatableBitSet init_scanColumnList;
    private DataValueDescriptor[] init_startKeyValue;
    private int init_startSearchOperator;
    private Qualifier[][] init_qualifier;
    private DataValueDescriptor[] init_stopKeyValue;
    private int init_stopSearchOperator;
    private FetchDescriptor init_fetchDesc;
    private int scan_state;
    protected RowPosition scan_position;
    protected int stat_numpages_visited = 0;
    protected int stat_numrows_visited = 0;
    protected int stat_numrows_qualified = 0;

    private final void repositionScanForUpateOper() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            throw StandardException.newException("XSAM6.S", this.open_conglom.getContainer().getId(), (Object)new Long(this.scan_position.current_rh.getId()));
        }
        if (this.open_conglom.isUseUpdateLocks()) {
            this.open_conglom.lockPositionForWrite(this.scan_position, false, true);
        }
    }

    protected void positionAtInitScan(DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2, RowPosition rowPosition) throws StandardException {
        this.init_startKeyValue = dataValueDescriptorArray;
        if (RowUtil.isRowEmpty(this.init_startKeyValue, null)) {
            this.init_startKeyValue = null;
        }
        this.init_startSearchOperator = n;
        if (qualifierArray != null && qualifierArray.length == 0) {
            qualifierArray = null;
        }
        this.init_qualifier = qualifierArray;
        this.init_fetchDesc = new FetchDescriptor(this.open_conglom.getRuntimeMem().get_scratch_row().length, this.init_scanColumnList, this.init_qualifier);
        this.init_stopKeyValue = dataValueDescriptorArray2;
        if (RowUtil.isRowEmpty(this.init_stopKeyValue, null)) {
            this.init_stopKeyValue = null;
        }
        this.init_stopSearchOperator = n2;
        rowPosition.init();
        this.scan_state = 1;
    }

    protected void positionAtResumeScan(RowPosition rowPosition) throws StandardException {
        this.open_conglom.latchPageAndRepositionScan(this.scan_position);
    }

    protected void positionAtStartForForwardScan(RowPosition rowPosition) throws StandardException {
        if (rowPosition.current_rh == null) {
            rowPosition.current_page = this.open_conglom.getContainer().getFirstPage();
            rowPosition.current_slot = 0;
        } else {
            this.open_conglom.latchPageAndRepositionScan(rowPosition);
            --rowPosition.current_slot;
        }
        rowPosition.current_rh = null;
        this.stat_numpages_visited = 1;
        this.scan_state = 2;
    }

    protected void positionAtNextPage(RowPosition rowPosition) throws StandardException {
        if (rowPosition.current_page != null) {
            long l = rowPosition.current_page.getPageNumber();
            rowPosition.unlatch();
            rowPosition.current_page = this.open_conglom.getContainer().getNextPage(l);
            rowPosition.current_slot = -1;
        }
    }

    protected void positionAtDoneScan(RowPosition rowPosition) throws StandardException {
        rowPosition.unlatch();
        if (this.scan_position.current_rh != null) {
            this.open_conglom.unlockPositionAfterRead(this.scan_position);
            this.scan_position.current_rh = null;
        }
        this.scan_state = 3;
    }

    public void reopenScanByRowLocation(RowLocation rowLocation, Qualifier[][] qualifierArray) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    protected RowPosition allocateScanPosition() throws StandardException {
        return new RowPosition();
    }

    protected int fetchRows(DataValueDescriptor[][] dataValueDescriptorArray, RowLocation[] rowLocationArray, BackingStoreHashtable backingStoreHashtable, long l, int[] nArray) throws StandardException {
        int n = 0;
        Object[] objectArray = null;
        if (l == -1L) {
            l = Long.MAX_VALUE;
        }
        if (this.scan_state == 2) {
            this.positionAtResumeScan(this.scan_position);
        } else if (this.scan_state == 1) {
            this.positionAtStartForForwardScan(this.scan_position);
        } else if (this.scan_state == 5) {
            this.open_conglom.reopen();
            this.open_conglom.latchPageAndRepositionScan(this.scan_position);
            this.scan_state = 2;
        } else if (this.scan_state == 4) {
            this.open_conglom.reopen();
            this.positionAtStartForForwardScan(this.scan_position);
        } else {
            return 0;
        }
        while (this.scan_position.current_page != null) {
            while (this.scan_position.current_slot + 1 < this.scan_position.current_page.recordCount()) {
                if (this.scan_position.current_rh != null) {
                    this.open_conglom.unlockPositionAfterRead(this.scan_position);
                }
                if (objectArray == null) {
                    if (backingStoreHashtable == null) {
                        if (dataValueDescriptorArray[n] == null) {
                            dataValueDescriptorArray[n] = this.open_conglom.getRuntimeMem().get_row_for_export();
                        }
                        objectArray = dataValueDescriptorArray[n];
                    } else {
                        objectArray = this.open_conglom.getRuntimeMem().get_row_for_export();
                    }
                }
                this.scan_position.positionAtNextSlot();
                boolean bl = this.open_conglom.lockPositionForRead(this.scan_position, null, true, true);
                if (!bl) {
                    if (this.scan_position.current_page == null) break;
                    if (this.scan_position.current_slot == -1) continue;
                }
                ++this.stat_numrows_visited;
                boolean bl2 = this.scan_position.current_rh_qualified = this.scan_position.current_page.fetchFromSlot(this.scan_position.current_rh, this.scan_position.current_slot, objectArray, this.init_fetchDesc, false) != null;
                if (!this.scan_position.current_rh_qualified) continue;
                ++n;
                ++this.stat_numrows_qualified;
                if (backingStoreHashtable == null) {
                    if (rowLocationArray != null) {
                        this.setRowLocationArray(rowLocationArray, n - 1, this.scan_position);
                    }
                    objectArray = null;
                } else if (backingStoreHashtable.put(false, objectArray)) {
                    objectArray = null;
                }
                if (l > (long)n) continue;
                this.scan_position.unlatch();
                return n;
            }
            this.positionAtNextPage(this.scan_position);
            ++this.stat_numpages_visited;
        }
        this.positionAtDoneScan(this.scan_position);
        --this.stat_numpages_visited;
        return n;
    }

    protected void reopenScanByRecordHandle(RecordHandle recordHandle, Qualifier[][] qualifierArray) throws StandardException {
        this.scan_state = !this.open_conglom.getHold() ? 1 : 4;
        this.scan_position.current_rh = recordHandle;
    }

    protected void setRowLocationArray(RowLocation[] rowLocationArray, int n, RowPosition rowPosition) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    public void init(OpenConglomerate openConglomerate, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        super.init(openConglomerate);
        this.scan_position = this.allocateScanPosition();
        this.init_scanColumnList = formatableBitSet;
        this.positionAtInitScan(dataValueDescriptorArray, n, qualifierArray, dataValueDescriptorArray2, n2, this.scan_position);
    }

    public final int getNumPagesVisited() {
        return this.stat_numpages_visited;
    }

    public final int getNumRowsVisited() {
        return this.stat_numrows_visited;
    }

    public final int getNumRowsQualified() {
        return this.stat_numrows_qualified;
    }

    public final FormatableBitSet getScanColumnList() {
        return this.init_scanColumnList;
    }

    public final DataValueDescriptor[] getStartKeyValue() {
        return this.init_startKeyValue;
    }

    public final int getStartSearchOperator() {
        return this.init_startSearchOperator;
    }

    public final DataValueDescriptor[] getStopKeyValue() {
        return this.init_stopKeyValue;
    }

    public final int getStopSearchOperator() {
        return this.init_stopSearchOperator;
    }

    public final Qualifier[][] getQualifier() {
        return this.init_qualifier;
    }

    public final int getScanState() {
        return this.scan_state;
    }

    public final void setScanState(int n) {
        this.scan_state = n;
    }

    public final RowPosition getScanPosition() {
        return this.scan_position;
    }

    public final void setScanPosition(RowPosition rowPosition) {
        this.scan_position = rowPosition;
    }

    private void closeScan() throws StandardException {
        super.close();
        if (this.open_conglom.getXactMgr() != null) {
            this.open_conglom.getXactMgr().closeMe(this);
        }
        this.init_qualifier = null;
        this.init_scanColumnList = null;
        this.init_startKeyValue = null;
        this.init_stopKeyValue = null;
    }

    public void close() throws StandardException {
        this.positionAtDoneScan(this.scan_position);
        this.closeScan();
    }

    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        if (!this.open_conglom.getHold() || bl) {
            this.scan_state = 3;
            this.closeScan();
            return true;
        }
        super.close();
        if (this.scan_state == 2) {
            this.scan_state = 5;
        } else if (this.scan_state == 1) {
            this.scan_state = 4;
        }
        return false;
    }

    public boolean delete() throws StandardException {
        this.repositionScanForUpateOper();
        boolean bl = true;
        if (this.scan_position.current_page.isDeletedAtSlot(this.scan_position.current_slot)) {
            bl = false;
        } else {
            this.scan_position.current_page.deleteAtSlot(this.scan_position.current_slot, true, null);
            if (this.scan_position.current_page.nonDeletedRecordCount() == 0) {
                this.queueDeletePostCommitWork(this.scan_position);
            }
        }
        this.scan_position.unlatch();
        return bl;
    }

    public void didNotQualify() throws StandardException {
    }

    public void fetchSet(long l, int[] nArray, BackingStoreHashtable backingStoreHashtable) throws StandardException {
        this.fetchRows(null, null, backingStoreHashtable, l, nArray);
    }

    public void reopenScan(DataValueDescriptor[] dataValueDescriptorArray, int n, Qualifier[][] qualifierArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        this.scan_state = !this.open_conglom.getHold() ? 1 : 4;
        this.scan_position.current_rh = null;
    }

    public boolean replace(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        this.repositionScanForUpateOper();
        boolean bl = this.scan_position.current_page.update(this.scan_position.current_rh, dataValueDescriptorArray, formatableBitSet);
        this.scan_position.unlatch();
        return bl;
    }

    public boolean doesCurrentPositionQualify() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            return false;
        }
        Object[] objectArray = this.open_conglom.getRuntimeMem().get_scratch_row();
        boolean bl = this.scan_position.current_page.fetchFromSlot(this.scan_position.current_rh, this.scan_position.current_slot, objectArray, this.init_fetchDesc, false) != null;
        this.scan_position.unlatch();
        return bl;
    }

    public void fetch(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            throw StandardException.newException("XSAM6.S", this.open_conglom.getContainer().getId(), (Object)new Long(this.scan_position.current_rh.getId()));
        }
        RecordHandle recordHandle = this.scan_position.current_page.fetchFromSlot(this.scan_position.current_rh, this.scan_position.current_slot, dataValueDescriptorArray, this.init_fetchDesc, false);
        this.scan_position.unlatch();
        if (recordHandle == null) {
            throw StandardException.newException("XSAM6.S", this.open_conglom.getContainer().getId(), (Object)new Long(this.scan_position.current_rh.getId()));
        }
    }

    public void fetchLocation(RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public ScanInfo getScanInfo() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public boolean isCurrentPositionDeleted() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S");
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            return true;
        }
        boolean bl = this.scan_position.current_page.isDeletedAtSlot(this.scan_position.current_slot);
        this.scan_position.unlatch();
        return bl;
    }
}

