/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.track;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.View;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqBlockTrack
extends Track {
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();
    List<Integer> occupiedSpace = new ArrayList<Integer>();
    private Color color;
    private int RESOLUTION = 512;
    private Color[] charColors = new Color[]{new Color(64, 192, 64, 128), new Color(64, 64, 192, 128), new Color(128, 128, 128, 128), new Color(192, 64, 64, 128)};
    private long maxBpLength;
    private boolean wasLastConsied = true;
    private long minBpLength;

    public SeqBlockTrack(View view, File file, Class<? extends AreaRequestHandler> handler, ReadInstructions<?> readInstructions, Color color, long minBpLength, long maxBpLength) {
        super(view, file, handler, readInstructions);
        this.color = color;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        this.occupiedSpace.clear();
        if (this.reads != null) {
            Iterator<RegionContent> iter = this.reads.iterator();
            while (iter.hasNext()) {
                int i;
                RegionContent read = iter.next();
                Object valueObj = read.values.get((Object)Content.VALUE);
                if (!read.region.intercepts(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                Color c = Color.gray;
                int height = 10;
                long startBp = read.region.start;
                long endBp = read.region.end;
                String seq = (String)read.values.get((Object)Content.SEQUENCE);
                if (seq != null) {
                    seq = seq.trim();
                } else {
                    int seqLength = (int)(endBp - startBp + 1L);
                    if (seqLength > 128) {
                        seqLength = 0;
                    }
                    seq = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA".substring(0, seqLength);
                }
                Rectangle rect = new Rectangle();
                rect.x = this.getView().bpToTrack(startBp);
                rect.width = this.getView().bpToTrack(endBp) - rect.x;
                for (i = 0; this.occupiedSpace.size() > i && this.occupiedSpace.get(i) > rect.x + 1; ++i) {
                }
                int end = rect.x + rect.width;
                if (this.occupiedSpace.size() > i) {
                    this.occupiedSpace.set(i, end);
                } else {
                    this.occupiedSpace.add(end);
                }
                rect.y = (int)(this.getView().getTrackHeight() - (float)((i + 1) * (height + 2)));
                rect.height = height;
                String strand = (String)read.values.get((Object)Content.STRAND);
                strand = strand != null ? strand.trim() : "F";
                if (strand.equals("R")) {
                    StringBuffer buf = new StringBuffer(seq).reverse();
                    seq = buf.toString();
                }
                if (rect.width < seq.length()) {
                    drawables.add(new RectDrawable(rect, c, null));
                    continue;
                }
                int CHAR_WIDTH = 7;
                float x = rect.x;
                float increment = (float)rect.width / (float)seq.length();
                for (int j = 0; j < seq.length(); ++j) {
                    char letter = seq.charAt(j);
                    if (rect.width > seq.length() * 7) {
                        drawables.add(new TextDrawable((int)x, rect.y + 8, "" + letter, Color.black));
                    }
                    Color bg = Color.white;
                    if (letter == 'A') {
                        bg = this.charColors[0];
                    } else if (letter == 'C') {
                        bg = this.charColors[1];
                    } else if (letter == 'G') {
                        bg = this.charColors[2];
                    } else if (letter == 'T') {
                        bg = this.charColors[3];
                    }
                    drawables.add(new RectDrawable((int)x, rect.y - 2, (int)increment, 10, bg, null));
                    x += increment;
                }
            }
        }
        return drawables;
    }

    @Override
    public void processAreaResult(AreaResult<RegionContent> areaResult) {
        if (areaResult.status.concise == this.isConcised() && this.isForForwardStrand(areaResult) != this.isReversed()) {
            this.reads.add((RegionContent)areaResult.content);
            this.getView().redraw();
        }
    }

    @Override
    public void updateData() {
        if (this.wasLastConsied != this.isConcised()) {
            this.reads.clear();
            this.wasLastConsied = this.isConcised();
        }
        super.updateData();
    }

    @Override
    public int getMaxHeight() {
        if (this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength) {
            return super.getMaxHeight();
        }
        return 0;
    }

    @Override
    public Collection<Content> getDefaultContents() {
        return Arrays.asList(Content.SEQUENCE, Content.STRAND, Content.QUALITY);
    }

    @Override
    public boolean isConcised() {
        return this.getView().getBpRegion().getLength() > 0x100000L;
    }
}

