/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Region
implements Comparable<Region> {
    public Long start;
    public long end;

    public Region(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public Region() {
        this(-1L, -1L);
    }

    public long getLength() {
        return this.end - this.start;
    }

    public long getMid() {
        return (this.start + this.end) / 2L;
    }

    public String toString() {
        return this.start + " - " + this.end;
    }

    public Region clone() {
        return new Region(this.start, this.end);
    }

    public boolean intercepts(Region other) {
        return this.end > other.start && this.start < other.end;
    }

    public Region intercept(Region other) {
        return new Region(Math.max(this.start, other.start), Math.min(this.end, other.end));
    }

    public void move(long move) {
        this.start = this.start + move;
        this.end += move;
    }

    @Override
    public int compareTo(Region o) {
        return this.start.compareTo(o.start);
    }

    public boolean equals(Object o) {
        if (o instanceof Region) {
            return this.start.equals(((Region)o).start);
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public boolean contains(Long point) {
        return point >= this.start && point < this.end;
    }
}

