/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ChunkParser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Conciser;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionLengthIntensityConciser
implements Conciser<Float> {
    @Override
    public Float concise(ByteChunk chunk, ChunkParser parser) {
        Content start = Content.BP_START;
        Content end = Content.BP_END;
        long total = 0L;
        long minBp = -1L;
        long maxBp = -1L;
        parser.setChunk(chunk);
        long rowCount = parser.getReadCount();
        int i = 0;
        while ((long)i < rowCount) {
            long startBp = parser.getLong((long)i + chunk.readIndex, start);
            long length = parser.getLong((long)i + chunk.readIndex, end) - startBp;
            total += length;
            if (i == 0) {
                minBp = startBp;
            }
            if ((long)i == rowCount - 1L) {
                maxBp = startBp;
            }
            ++i;
        }
        return Float.valueOf((float)total / (float)(maxBp - minBp));
    }

    @Override
    public Region getRegion(ChunkParser parser, long readIndex) {
        return new Region(parser.getLong(readIndex, Content.BP_START), parser.getLong(readIndex, Content.BP_END));
    }
}

