/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.ByteChunk;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Content;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.DataFieldDef;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.FileDefinition;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChunkParser {
    protected ByteChunk chunk;
    protected FileDefinition fileDef;

    public ChunkParser(FileDefinition fileDef) {
        this.fileDef = fileDef;
    }

    public void setChunk(ByteChunk chunk) {
        this.chunk = chunk;
    }

    public abstract ChunkParser clone();

    public abstract long getReadCount();

    protected abstract long getPosition(long var1, Content var3);

    protected abstract String getString(long var1);

    protected abstract long getLong(long var1);

    protected abstract float getFloat(long var1);

    public String getString(long readIndex, Content field) {
        return this.getString(this.getPosition(readIndex, field));
    }

    public long getLong(long readIndex, Content field) {
        return this.getLong(this.getPosition(readIndex, field));
    }

    public float getFloat(long readIndex, Content field) {
        return this.getFloat(this.getPosition(readIndex, field));
    }

    public Object get(long pos, Type type) {
        if (type == Type.FLOAT) {
            return Float.valueOf(this.getFloat(pos));
        }
        if (type == Type.LONG) {
            return this.getLong(pos);
        }
        if (type == Type.STRING) {
            return this.getString(pos);
        }
        return null;
    }

    public List<Object> getRead(long readIndex) {
        LinkedList<Object> fields = new LinkedList<Object>();
        for (DataFieldDef field : this.fileDef) {
            fields.add(this.get(this.getPosition(readIndex, field.content), this.fileDef.getFieldDef((Content)field.content).type));
        }
        return fields;
    }

    public Map<Content, Object> getValues(long l, Collection<Content> requestedContents) {
        HashMap<Content, Object> values = new HashMap<Content, Object>();
        for (Content requestedContent : requestedContents) {
            if (this.fileDef.getFieldDef(requestedContent) == null) continue;
            values.put(requestedContent, this.get(this.getPosition(l, requestedContent), this.fileDef.getFieldDef((Content)requestedContent).type));
        }
        return values;
    }
}

