/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.AreaResultListener;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.FileFetcherThread;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.dataFetcher.TreeNode;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.fileFormat.ReadInstructions;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FileRequest;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FileResult;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.FsfStatus;
import fi.csc.microarray.client.visualisation.methods.genomeBrowser.message.Region;
import java.io.File;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeThread<T>
extends AreaRequestHandler {
    private TreeNode<T> rootNode;
    private BlockingQueue<FileRequest> fileRequestQueue = new LinkedBlockingQueue<FileRequest>();
    private ConcurrentLinkedQueue<FileResult> fileResultQueue = new ConcurrentLinkedQueue();
    private FileFetcherThread fileFetcher;
    private boolean debug = false;
    private ReadInstructions<T> instructions;
    private File file;

    public TreeThread(File file, Queue<AreaRequest> areaRequestQueue, AreaResultListener areaResultListener, ReadInstructions<T> instructions) {
        super(areaRequestQueue, areaResultListener);
        this.instructions = instructions;
        this.file = file;
    }

    @Override
    public synchronized void run() {
        this.fileFetcher = new FileFetcherThread(this.fileRequestQueue, this.fileResultQueue, this, this.instructions);
        this.createTree(this.fileFetcher.getRowCount());
        this.fileFetcher.start();
        super.run();
    }

    @Override
    protected boolean checkOtherQueues() {
        FileResult fileResult = this.fileResultQueue.poll();
        if (fileResult != null) {
            fileResult.status.fileResultCount = this.fileResultQueue.size();
            this.processFileResult(fileResult);
        }
        return fileResult != null;
    }

    private void createTree(long rowCount) {
        this.rootNode = new TreeNode(new Region(0L, rowCount), this, null);
    }

    private void processFileResult(FileResult fileResult) {
        fileResult.request.node.processFileResult(fileResult);
    }

    @Override
    protected void processAreaRequest(AreaRequest areaRequest) {
        if (this.debug) {
            System.out.println("Tree: Got area request " + areaRequest);
        }
        this.rootNode.processAreaRequest(areaRequest);
    }

    public void createFileRequest(AreaRequest areaRequest, Region rowRegion, TreeNode node, FsfStatus status) {
        if (this.debug) {
            System.out.println("Tree: Creating file request");
        }
        status.maybeClearQueue(this.fileRequestQueue);
        this.fileRequestQueue.add(new FileRequest(areaRequest, rowRegion, node, status));
    }

    public ReadInstructions<T> getInstructions() {
        return this.instructions;
    }

    public File getFile() {
        return this.file;
    }
}

