/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.visualisation.Visualisation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.HCPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.OverlayLayout;
import org.jfree.ui.RectangleEdge;

public class SelectableChartPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private TransparentPanel transparentPanel;
    private ChartPanel chartPanel;
    private SelectionChangeListener selectionListener;
    private Rectangle2D.Double selection;
    private final boolean isZoomable = false;
    private final boolean useZoomOutline = false;
    private Point startCoords;
    private boolean isDragged = false;

    public SelectableChartPanel(JFreeChart chart, SelectionChangeListener selectionListener) {
        this(chart, selectionListener, true);
    }

    public SelectableChartPanel(JFreeChart chart, SelectionChangeListener selectionListener, boolean scalable) {
        super((LayoutManager)new OverlayLayout());
        this.selectionListener = selectionListener;
        this.chartPanel = scalable ? Visualisation.makePanel(chart) : Visualisation.makenNonScalablePanel(chart);
        this.transparentPanel = new TransparentPanel();
        this.add(this.transparentPanel);
        this.add((Component)this.chartPanel);
        this.chartPanel.addMouseListener((MouseListener)this);
        this.chartPanel.addMouseMotionListener((MouseMotionListener)this);
        this.chartPanel.setMouseZoomable(false);
    }

    public Rectangle2D.Double translateToChart(Rectangle mouseCoords) {
        Point corner1 = new Point((int)mouseCoords.getMinX(), (int)mouseCoords.getMinY());
        Point corner2 = new Point((int)mouseCoords.getMaxX(), (int)mouseCoords.getMaxY());
        Point2D.Double translated1 = this.translateToChart(corner1);
        Point2D.Double translated2 = this.translateToChart(corner2);
        return this.createOrderedRectangle(translated1, translated2);
    }

    public Point2D.Double translateToChart(Point mouseCoords) {
        Insets insets = this.getInsets();
        int mouseX = (int)((mouseCoords.getX() - (double)insets.left) / this.chartPanel.getScaleX());
        int mouseY = (int)((mouseCoords.getY() - (double)insets.top) / this.chartPanel.getScaleY());
        Point2D p = this.chartPanel.translateScreenToJava2D(new Point(mouseX, mouseY));
        Plot plot = this.chartPanel.getChart().getPlot();
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
            Rectangle2D dataArea = info.getPlotInfo().getDataArea();
            ValueAxis domainAxis = xyPlot.getDomainAxis();
            RectangleEdge domainAxisEdge = xyPlot.getDomainAxisEdge();
            ValueAxis rangeAxis = xyPlot.getRangeAxis();
            RectangleEdge rangeAxisEdge = xyPlot.getRangeAxisEdge();
            double chartX = domainAxis.java2DToValue(p.getX() * this.chartPanel.getScaleX(), dataArea, domainAxisEdge);
            double chartY = rangeAxis.java2DToValue(p.getY() * this.chartPanel.getScaleY(), dataArea, rangeAxisEdge);
            return new Point2D.Double(chartX, chartY);
        }
        if (plot instanceof CategoryPlot) {
            CategoryPlot catPlot = (CategoryPlot)plot;
            ChartRenderingInfo info = this.chartPanel.getChartRenderingInfo();
            Rectangle2D dataArea = info.getPlotInfo().getDataArea();
            CategoryAxis domainAxis = catPlot.getDomainAxis();
            RectangleEdge domainAxisEdge = catPlot.getDomainAxisEdge();
            int categoryCount = catPlot.getCategories().size();
            ValueAxis rangeAxis = catPlot.getRangeAxis();
            RectangleEdge rangeAxisEdge = catPlot.getRangeAxisEdge();
            double firstCategoryX = domainAxis.getCategoryJava2DCoordinate(catPlot.getDomainGridlinePosition(), 0, categoryCount, dataArea, domainAxisEdge);
            double lastCategoryX = domainAxis.getCategoryJava2DCoordinate(catPlot.getDomainGridlinePosition(), categoryCount - 1, categoryCount, dataArea, domainAxisEdge);
            double scaledX = p.getX() * this.chartPanel.getScaleX();
            double chartY = rangeAxis.java2DToValue(p.getY() * this.chartPanel.getScaleY(), dataArea, rangeAxisEdge);
            double relativeX = (scaledX - firstCategoryX) / (lastCategoryX - firstCategoryX) * (double)(categoryCount - 1);
            return new Point2D.Double(relativeX, chartY);
        }
        if (plot instanceof HCPlot) {
            Insets chartInsets = this.getInsets();
            int x = (int)((p.getX() - (double)chartInsets.left) * this.chartPanel.getScaleX());
            int y = (int)((p.getY() - (double)chartInsets.top) * this.chartPanel.getScaleY());
            return new Point2D.Double(x, y);
        }
        throw new UnsupportedOperationException("Only Category, XY and HC plots are supported until now");
    }

    public Rectangle2D.Double getSelectionRectangle() {
        return this.selection;
    }

    public void mouseClicked(MouseEvent e) {
        if (!e.isControlDown()) {
            this.setSelection(null);
        }
        Rectangle rect = new Rectangle((int)e.getPoint().getX(), (int)e.getPoint().getY(), 0, 0);
        rect.grow(3, 3);
        Rectangle2D.Double translatedRect = this.translateToChart(rect);
        this.setSelection(translatedRect);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.startCoords = e.getPoint();
        this.isDragged = false;
    }

    public void mouseReleased(MouseEvent e) {
        this.transparentPanel.setArea(null);
        this.transparentPanel.repaint();
        if (this.isDragged) {
            if (!e.isControlDown()) {
                this.setSelection(null);
            }
            Point2D.Double translatedStart = this.translateToChart(this.startCoords);
            Point2D.Double translatedEnd = this.translateToChart(e.getPoint());
            this.setSelection(this.createOrderedRectangle(translatedStart, translatedEnd));
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.isDragged = true;
        this.transparentPanel.setArea(this.createOrderedRectangle(this.startCoords, e.getPoint()).getBounds());
        this.transparentPanel.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    private Rectangle2D.Double createOrderedRectangle(Point2D p1, Point2D p2) {
        double x = p1.getX() < p2.getX() ? p1.getX() : p2.getX();
        double y = p1.getY() < p2.getY() ? p1.getY() : p2.getY();
        double w = Math.abs(p2.getX() - p1.getX());
        double h = Math.abs(p2.getY() - p1.getY());
        return new Rectangle2D.Double(x, y, w, h);
    }

    private void setSelection(Rectangle2D.Double selection) {
        this.selection = selection;
        if (this.selectionListener != null) {
            this.selectionListener.selectionChanged(this.selection);
        }
    }

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    protected class TransparentPanel
    extends JPanel {
        private Rectangle2D area;

        public TransparentPanel() {
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            super.paintComponents(g);
            if (this.area != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(Color.DARK_GRAY);
                g2d.setStroke(VisualConstants.dashLine);
                g2d.draw(this.area);
            }
        }

        protected void setArea(Rectangle area) {
            this.area = area;
        }
    }

    public static interface SelectionChangeListener {
        public void selectionChanged(Rectangle2D.Double var1);
    }
}

