/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation;

import fi.csc.microarray.MicroarrayException;
import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.selection.RowSelectionManager;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.features.Table;
import fi.csc.microarray.util.ThreadUtils;
import fi.csc.microarray.wizard.ResultBlocker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualisationUtilities {
    private static final ClientApplication application = Session.getSession().getApplication();

    public static DataBean filterBySelection(List<DataBean> datas) {
        try {
            if (datas.size() == 1) {
                List<String> lines = application.getSelectionManager().getRowSelectionManager(datas.get(0)).getSelectedLines();
                return RowSelectionManager.createDataset(lines, datas.toArray(new DataBean[datas.size()]));
            }
            LinkedList<String[]> allColumns = new LinkedList<String[]>();
            for (DataBean data : datas) {
                if (application.getSelectionManager().getRowSelectionManager(data).getSelectedRows().length <= 0) continue;
                allColumns.add(data.queryFeatures("/column/*").asTable().getColumnNames());
            }
            ArrayList<String> columnOrder = new ArrayList<String>();
            while (allColumns.size() > 0) {
                int mostColumns = 0;
                for (String[] columnList : allColumns) {
                    if (columnList.length <= ((String[])allColumns.get(mostColumns)).length) continue;
                    mostColumns = allColumns.indexOf(columnList);
                }
                for (String col : (String[])allColumns.get(mostColumns)) {
                    if (columnOrder.contains(col)) continue;
                    columnOrder.add(col);
                }
                allColumns.remove(mostColumns);
            }
            Map<String, Map<String, String>> values = VisualisationUtilities.getSelectedFromMultipleDatas(datas);
            ArrayList<String> lines = new ArrayList<String>();
            String newLine = "";
            for (String colName : columnOrder) {
                newLine = newLine + colName + "\t";
            }
            if (newLine.endsWith("\t")) {
                newLine = newLine.substring(0, newLine.length() - 1);
            }
            lines.add(newLine);
            for (String id : values.keySet()) {
                newLine = "";
                Map<String, String> rowValues = values.get(id);
                for (String colName : columnOrder) {
                    String value = rowValues.get(colName);
                    if (value == null) {
                        value = "";
                    }
                    newLine = newLine + value + "\t";
                }
                if (newLine.endsWith("\t")) {
                    newLine = newLine.substring(0, newLine.length() - 1);
                }
                lines.add(newLine);
            }
            return RowSelectionManager.createDataset(lines, datas.toArray(new DataBean[datas.size()]));
        }
        catch (Exception exp) {
            application.reportException(new MicroarrayException("Unable to create user filtered dataset", exp));
            return null;
        }
    }

    public static Map<String, Map<String, String>> getSelectedFromMultipleDatas(List<DataBean> datas) throws Exception {
        HashMap<String, Map<String, String>> lines = new HashMap<String, Map<String, String>>();
        for (DataBean data : datas) {
            Table columns = data.queryFeatures("/column/*").asTable();
            int[] indexes = application.getSelectionManager().getRowSelectionManager(data).getSelectedRows();
            Arrays.sort(indexes);
            int i = 0;
            while (columns.nextRow()) {
                if (Arrays.binarySearch(indexes, i) >= 0) {
                    String id;
                    HashMap<String, String> newColumns = new HashMap<String, String>();
                    for (String columnName : columns.getColumnNames()) {
                        newColumns.put(columnName, columns.getValue(columnName).toString());
                    }
                    String string = id = newColumns.containsKey(" ") ? (String)newColumns.get(" ") : (String)newColumns.get("identifier");
                    if (!lines.containsKey(id)) {
                        lines.put(id, newColumns);
                    }
                    ((Map)lines.get(id)).putAll(newColumns);
                }
                ++i;
            }
        }
        return lines;
    }

    public static void annotateBySelection(List<DataBean> datas) {
        try {
            final DataBean filterBySelection = VisualisationUtilities.filterBySelection(datas);
            Thread thread = ThreadUtils.getBackgroundThread(new Runnable(){

                public void run() {
                    try {
                        Operation normOp = new Operation(application.locateOperationDefinition("Annotation", "Agilent, Affymetrix or Illumina genelist"), new DataBean[]{filterBySelection});
                        ResultBlocker normBlocker = new ResultBlocker(2);
                        normOp.setResultListener(normBlocker);
                        application.executeOperation(normOp);
                    }
                    catch (MicroarrayException e) {
                        application.reportException(e);
                    }
                }
            });
            thread.start();
        }
        catch (Exception exp) {
            application.reportException(new MicroarrayException("Unable to collect identifiers for annotation", exp));
        }
    }

    public static Visualisation.Variable[] getVariablesFilteredInclusive(DataBean dataBean, String startsWith, boolean removeStart) {
        String exprHeader = "/column/";
        LinkedList<Visualisation.Variable> vars = new LinkedList<Visualisation.Variable>();
        try {
            Table columns = dataBean.queryFeatures("/column/*").asTable();
            for (String columnName : columns.getColumnNames()) {
                if (!columnName.startsWith(startsWith)) continue;
                String chipName = removeStart ? columnName.substring(startsWith.length()) : columnName;
                String expression = exprHeader + columnName;
                vars.add(new Visualisation.Variable(chipName, expression));
            }
        }
        catch (MicroarrayException e) {
            application.reportException(new MicroarrayException("no chips to visualise"));
        }
        return vars.toArray(new Visualisation.Variable[0]);
    }

    public static Visualisation.Variable[] getVariablesFilteredExclusive(DataBean dataBean, Collection<String> columnsToRemove, boolean removeStart) {
        LinkedList filteredVars = new LinkedList();
        LinkedList<Visualisation.Variable> allVars = new LinkedList<Visualisation.Variable>();
        allVars.addAll(Arrays.asList(VisualisationUtilities.getVariablesFilteredInclusive(dataBean, "", false)));
        filteredVars.addAll(allVars);
        String hidden = "chip.";
        for (Visualisation.Variable var : allVars) {
            for (String colToRemove : columnsToRemove) {
                if (!var.getName().startsWith(colToRemove)) continue;
                filteredVars.remove(var);
            }
            if (!removeStart || !var.getName().startsWith(hidden)) continue;
            String chipName = var.getName().substring(hidden.length());
            filteredVars.set(filteredVars.indexOf(var), new Visualisation.Variable(chipName, var.getExpression()));
        }
        return filteredVars.toArray(new Visualisation.Variable[0]);
    }
}

