/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataview;

import fi.csc.microarray.client.dataviews.vertexes.AbstractGraphVertex;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class PositionChangeAnimator
implements ActionListener {
    private Point from;
    private Point to;
    private int frame = 1;
    private AbstractGraphVertex cell;
    private Timer timer;
    private static boolean isBusy = false;
    public static final int FRAME_COUNT = 5;

    public PositionChangeAnimator(AbstractGraphVertex cell, Point from, Point to) {
        this.cell = cell;
        this.from = from;
        this.to = to;
        this.timer = new Timer(50, this);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (!isBusy) {
            isBusy = true;
            if (this.frame <= 5) {
                Point point = new Point();
                double factor = this.getFactor(this.frame);
                point.x = (int)(this.to.getX() - (this.to.getX() - this.from.getX()) * factor);
                point.y = (int)(this.to.getY() - (this.to.getY() - this.from.getY()) * factor);
                this.cell.setPosition(point);
            } else {
                this.cell.setPosition(this.to);
                this.timer.stop();
            }
            isBusy = false;
        }
        ++this.frame;
    }

    private double getFactor(double frame) {
        return 1.0 / frame - 0.2;
    }
}

