/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataview;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.VisualConstants;
import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.parameter.Parameter;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataItem;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DetailsPanel
extends JPanel
implements PropertyChangeListener,
FocusListener,
ActionListener,
DocumentListener {
    public static final int MINIMISED_HEIGHT = 30;
    private final Color NOTES_BACKGROUND = Color.WHITE;
    private final String PLEASE_ADD_NOTES = "Add your notes here...";
    private final String NO_DATASET_SELECTED = "No dataset selected";
    private final String CL_MINIMISED = "minimised-panel";
    private final int CL_MINIMISED_INDEX = 0;
    private final String CL_MAIN = "main-panel";
    private final int CL_MAIN_INDEX = 1;
    private JTextArea attributesField = new JTextArea();
    private JLabel nameField = new JLabel();
    private JTextArea notesField = new JTextArea();
    private JLabel minimisedNotesField = new JLabel();
    private JButton hideButton = new JButton("Hide");
    private JButton showButton = new JButton("Show");
    private JScrollPane detailsScroller;
    private JPanel panelChanger = new JPanel(new CardLayout());
    private DataBean currentData;
    private ClientApplication application = Session.getSession().getApplication();
    JComponent parent;

    public DetailsPanel(JComponent parent) {
        this.parent = parent;
        this.nameField.setForeground(VisualConstants.DETAILS_NAME_FOREGROUND_COLOR);
        this.attributesField.setEditable(false);
        this.attributesField.setLineWrap(true);
        this.attributesField.setWrapStyleWord(true);
        this.attributesField.setForeground(VisualConstants.DETAILS_ATTRIBUTES_FOREGROUND_COLOR);
        this.attributesField.setBackground(VisualConstants.TEXTAREA_UNEDITABLE_BACKGROUND);
        this.minimisedNotesField.addFocusListener(this);
        this.notesField.setEditable(true);
        this.notesField.setLineWrap(true);
        this.notesField.setWrapStyleWord(true);
        this.notesField.setBackground(this.NOTES_BACKGROUND);
        this.notesField.addFocusListener(this);
        this.notesField.getDocument().addDocumentListener(this);
        JScrollPane notesScroller = new JScrollPane(this.notesField);
        notesScroller.setBorder(BorderFactory.createEmptyBorder());
        notesScroller.setPreferredSize(new Dimension(200, 20));
        JPanel contentPane = new JPanel(new BorderLayout());
        JPanel upperPanel = new JPanel(new BorderLayout());
        this.hideButton.addActionListener(this);
        JPanel upperUpperPanel = new JPanel(new BorderLayout());
        upperUpperPanel.add((Component)this.hideButton, "East");
        upperUpperPanel.add((Component)this.nameField, "Center");
        upperPanel.add((Component)upperUpperPanel, "North");
        upperPanel.add((Component)this.attributesField, "Center");
        contentPane.add((Component)upperPanel, "North");
        contentPane.add((Component)notesScroller, "Center");
        contentPane.setPreferredSize(new Dimension(240, 115));
        this.detailsScroller = new JScrollPane(contentPane);
        this.detailsScroller.setBorder(null);
        this.detailsScroller.setHorizontalScrollBarPolicy(30);
        this.detailsScroller.setVerticalScrollBarPolicy(20);
        this.detailsScroller.setPreferredSize(new Dimension(360, 135));
        JPanel minimisedPanel = new JPanel(new BorderLayout());
        JPanel innerMinimisedPanel = new JPanel(new BorderLayout());
        innerMinimisedPanel.setMinimumSize(new Dimension(0, 0));
        this.showButton.addActionListener(this);
        innerMinimisedPanel.add((Component)this.showButton, "East");
        innerMinimisedPanel.add((Component)this.minimisedNotesField, "West");
        minimisedPanel.add((Component)innerMinimisedPanel, "North");
        minimisedPanel.setPreferredSize(new Dimension(360, 30));
        minimisedPanel.setMinimumSize(new Dimension(0, 0));
        this.panelChanger.add((Component)minimisedPanel, "minimised-panel");
        this.panelChanger.add((Component)this.detailsScroller, "main-panel");
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelChanger, "Center");
        this.setPreferredSize(this.panelChanger.getComponent(0).getPreferredSize());
        this.setMinimumSize(new Dimension(0, 0));
        this.disable();
        this.application.addPropertyChangeListener(this);
    }

    private String getNameText() {
        if (this.currentData != null) {
            return this.currentData.getOperation().getName();
        }
        return null;
    }

    private String getAttributeText() {
        if (this.currentData != null) {
            StringBuffer attrib = new StringBuffer();
            attrib.append(this.currentData.getDate().toString());
            Operation lastOper = this.currentData.getOperation();
            if (lastOper != null) {
                attrib.append("\nOperation: " + lastOper.getCategoryName() + " / " + lastOper.getName());
                LinkedList<Parameter> params = lastOper.getParameters();
                if (params != null) {
                    attrib.append("\n");
                    for (int i = 0; i < params.size(); ++i) {
                        attrib.append(((Parameter)params.get(i)).toString());
                        if (i == params.size() - 1) continue;
                        attrib.append(", ");
                    }
                }
            }
            return attrib.toString();
        }
        return null;
    }

    public void setViewedData(DataItem data) {
        if (data != null && data instanceof DataBean) {
            DataBean dataBean;
            this.currentData = dataBean = (DataBean)data;
            this.nameField.setText(this.getNameText());
            this.attributesField.setText(this.getAttributeText());
            this.setNotes(dataBean.getNotes());
            this.notesField.setEnabled(true);
            this.notesField.setBackground(this.NOTES_BACKGROUND);
        } else {
            this.disable();
        }
    }

    public void disable() {
        this.currentData = null;
        this.minimisedNotesField.setText("No dataset selected");
        this.nameField.setText("No dataset selected");
        this.attributesField.setText("");
        this.notesField.setText("");
        this.notesField.setEnabled(false);
        this.notesField.setBorder(null);
    }

    private void setNotes(String text) {
        this.minimisedNotesField.setText(this.getNameText());
        if (text == null || "".equals(text.trim())) {
            this.notesField.setText("Add your notes here...");
        } else {
            this.notesField.setText(text);
        }
    }

    private String getNotes() {
        if ("Add your notes here...".equals(this.notesField.getText())) {
            return "";
        }
        return this.notesField.getText();
    }

    private void showPanel(String name, int index) {
        ((CardLayout)this.panelChanger.getLayout()).show(this.panelChanger, name);
        this.setPreferredSize(this.panelChanger.getComponent(index).getPreferredSize());
        this.parent.validate();
    }

    public void focusGained(FocusEvent e) {
        if ("Add your notes here...".equals(this.notesField.getText())) {
            this.notesField.setText("");
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hideButton) {
            this.showPanel("minimised-panel", 0);
        } else if (e.getSource() == this.showButton) {
            this.showPanel("main-panel", 1);
        }
    }

    public void propertyChange(PropertyChangeEvent dataEvent) {
        DataItem data = this.application.getSelectionManager().getSelectedItem();
        this.setViewedData(data);
    }

    public void changedUpdate(DocumentEvent e) {
        this.notesFieldUpdated();
    }

    public void insertUpdate(DocumentEvent e) {
        this.notesFieldUpdated();
    }

    public void removeUpdate(DocumentEvent e) {
        this.notesFieldUpdated();
    }

    private void notesFieldUpdated() {
        if (this.currentData != null) {
            this.currentData.setNotes(this.getNotes());
        }
    }
}

