/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.EndpointInject;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit38.AbstractJUnit38SpringContextTests;

@ContextConfiguration
public class SetHeaderTest
extends AbstractJUnit38SpringContextTests {
    private static final transient Log LOG = LogFactory.getLog(SetHeaderTest.class);
    @Autowired
    protected CamelContext camelContext;
    @EndpointInject(uri="mock:results")
    protected MockEndpoint expectedEndpoint;

    public void testMocksAreValid() throws Exception {
        this.expectedEndpoint.expectedMessageCount(1);
        this.expectedEndpoint.message(0).header("JMSXGroupID").isEqualTo((Object)"ABC");
        MockEndpoint.assertIsSatisfied((CamelContext)this.camelContext);
        List list = this.expectedEndpoint.getReceivedExchanges();
        for (Exchange exchange : list) {
            Object body = exchange.getIn().getBody();
            LOG.debug("Received: body: " + body + " of type: " + ObjectHelper.className((Object)body) + " on: " + exchange);
        }
    }
}

