/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.advisory.AdvisoryBroker;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQQueue;

public class TempQueueMemoryTest
extends EmbeddedBrokerTestSupport {
    private Connection serverConnection;
    private Session serverSession;
    private Connection clientConnection;
    private Session clientSession;
    private Destination serverDestination;
    private static final int COUNT = 1000;

    public void testLoadRequestReply() throws Exception {
        MessageConsumer serverConsumer = this.serverSession.createConsumer(this.serverDestination);
        serverConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    Destination replyTo = msg.getJMSReplyTo();
                    MessageProducer producer = TempQueueMemoryTest.this.serverSession.createProducer(replyTo);
                    producer.send(replyTo, msg);
                    producer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        MessageProducer producer = this.clientSession.createProducer(this.serverDestination);
        for (int i = 0; i < 1000; ++i) {
            TemporaryQueue replyTo = this.clientSession.createTemporaryQueue();
            MessageConsumer consumer = this.clientSession.createConsumer(replyTo);
            Message msg = this.clientSession.createMessage();
            msg.setJMSReplyTo(replyTo);
            producer.send(msg);
            Message reply = consumer.receive();
            consumer.close();
            replyTo.delete();
        }
        this.clientSession.close();
        this.serverSession.close();
        this.clientConnection.close();
        this.serverConnection.close();
        AdvisoryBroker ab = (AdvisoryBroker)this.broker.getBroker().getAdaptor(AdvisoryBroker.class);
        TempQueueMemoryTest.assertTrue((ab.getAdvisoryDestinations().size() == 1 ? 1 : 0) != 0);
        TempQueueMemoryTest.assertTrue((String)("should be zero but is " + ab.getAdvisoryConsumers().size()), (ab.getAdvisoryConsumers().size() == 0 ? 1 : 0) != 0);
        TempQueueMemoryTest.assertTrue((String)("should be zero but is " + ab.getAdvisoryProducers().size()), (ab.getAdvisoryProducers().size() == 0 ? 1 : 0) != 0);
        RegionBroker rb = (RegionBroker)this.broker.getBroker().getAdaptor(RegionBroker.class);
        TempQueueMemoryTest.assertTrue((rb.getDestinationMap().size() == 6 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.serverConnection = this.createConnection();
        this.serverConnection.start();
        this.serverSession = this.serverConnection.createSession(false, 0);
        this.clientConnection = this.createConnection();
        this.clientConnection.start();
        this.clientSession = this.clientConnection.createSession(false, 0);
        this.serverDestination = this.createDestination();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Destination createDestination() {
        return new ActiveMQQueue(((Object)((Object)this)).getClass().getName());
    }
}

