/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.command.ActiveMQQueue;

public class RedeliveryPolicyTest
extends JmsTestSupport {
    public static Test suite() {
        return RedeliveryPolicyTest.suite(RedeliveryPolicyTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RedeliveryPolicyTest.suite());
    }

    public void testExponentialRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(500L);
        policy.setBackOffMultiplier((short)2);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue(this.getName());
        MessageProducer producer = session.createProducer(destination);
        MessageConsumer consumer = session.createConsumer(destination);
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(500L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
    }

    public void testNornalRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(500L);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue(this.getName());
        MessageProducer producer = session.createProducer(destination);
        MessageConsumer consumer = session.createConsumer(destination);
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
    }

    public void testDLQHandling() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer(destination);
        MessageConsumer consumer = session.createConsumer(destination);
        MessageConsumer dlqConsumer = session.createConsumer(new ActiveMQQueue("ActiveMQ.DLQ"));
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
    }

    public void testInfiniteMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(-1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer(destination);
        MessageConsumer consumer = session.createConsumer(destination);
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testZeroMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(0);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer(destination);
        MessageConsumer consumer = session.createConsumer(destination);
        producer.send(session.createTextMessage("1st"));
        producer.send(session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }
}

